/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.animation.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v112.animation.model.KeyframeStyle;
import org.openqa.selenium.json.JsonInput;

public class KeyframesRule {
    private final Optional<String> name;
    private final List<KeyframeStyle> keyframes;

    public KeyframesRule(Optional<String> name2, List<KeyframeStyle> keyframes) {
        this.name = name2;
        this.keyframes = Objects.requireNonNull(keyframes, "keyframes is required");
    }

    public Optional<String> getName() {
        return this.name;
    }

    public List<KeyframeStyle> getKeyframes() {
        return this.keyframes;
    }

    private static KeyframesRule fromJson(JsonInput input) {
        Optional<String> name2 = Optional.empty();
        List keyframes = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name2 = Optional.ofNullable(input.nextString());
                    continue block8;
                }
                case "keyframes": {
                    keyframes = (List)input.read(new TypeToken<List<KeyframeStyle>>(){}.getType());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new KeyframesRule(name2, keyframes);
    }
}

