/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.layertree;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v112.dom.model.Rect;
import org.openqa.selenium.devtools.v112.layertree.model.Layer;
import org.openqa.selenium.devtools.v112.layertree.model.LayerId;
import org.openqa.selenium.devtools.v112.layertree.model.LayerPainted;
import org.openqa.selenium.devtools.v112.layertree.model.PaintProfile;
import org.openqa.selenium.devtools.v112.layertree.model.PictureTile;
import org.openqa.selenium.devtools.v112.layertree.model.SnapshotId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class LayerTree {
    public static Command<CompositingReasonsResponse> compositingReasons(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        ImmutableMap.Builder<String, LayerId> params = ImmutableMap.builder();
        params.put("layerId", layerId);
        return new Command<CompositingReasonsResponse>("LayerTree.compositingReasons", params.build(), input -> (CompositingReasonsResponse)input.read((Type)((Object)CompositingReasonsResponse.class)));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("LayerTree.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("LayerTree.enable", params.build());
    }

    public static Command<SnapshotId> loadSnapshot(List<PictureTile> tiles) {
        Objects.requireNonNull(tiles, "tiles is required");
        ImmutableMap.Builder<String, List<PictureTile>> params = ImmutableMap.builder();
        params.put("tiles", tiles);
        return new Command<SnapshotId>("LayerTree.loadSnapshot", params.build(), ConverterFunctions.map("snapshotId", SnapshotId.class));
    }

    public static Command<SnapshotId> makeSnapshot(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        ImmutableMap.Builder<String, LayerId> params = ImmutableMap.builder();
        params.put("layerId", layerId);
        return new Command<SnapshotId>("LayerTree.makeSnapshot", params.build(), ConverterFunctions.map("snapshotId", SnapshotId.class));
    }

    public static Command<List<PaintProfile>> profileSnapshot(SnapshotId snapshotId, Optional<Integer> minRepeatCount, Optional<Number> minDuration, Optional<Rect> clipRect) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder<String, SnapshotId> params = ImmutableMap.builder();
        params.put("snapshotId", snapshotId);
        minRepeatCount.ifPresent(p -> params.put("minRepeatCount", (SnapshotId)p));
        minDuration.ifPresent(p -> params.put("minDuration", (SnapshotId)p));
        clipRect.ifPresent(p -> params.put("clipRect", (SnapshotId)p));
        return new Command<List<PaintProfile>>("LayerTree.profileSnapshot", params.build(), ConverterFunctions.map("timings", new TypeToken<List<PaintProfile>>(){}.getType()));
    }

    public static Command<Void> releaseSnapshot(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder<String, SnapshotId> params = ImmutableMap.builder();
        params.put("snapshotId", snapshotId);
        return new Command<Void>("LayerTree.releaseSnapshot", params.build());
    }

    public static Command<String> replaySnapshot(SnapshotId snapshotId, Optional<Integer> fromStep, Optional<Integer> toStep, Optional<Number> scale) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder<String, SnapshotId> params = ImmutableMap.builder();
        params.put("snapshotId", snapshotId);
        fromStep.ifPresent(p -> params.put("fromStep", (SnapshotId)p));
        toStep.ifPresent(p -> params.put("toStep", (SnapshotId)p));
        scale.ifPresent(p -> params.put("scale", (SnapshotId)p));
        return new Command<String>("LayerTree.replaySnapshot", params.build(), ConverterFunctions.map("dataURL", String.class));
    }

    public static Command<List<Map<String, Object>>> snapshotCommandLog(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        ImmutableMap.Builder<String, SnapshotId> params = ImmutableMap.builder();
        params.put("snapshotId", snapshotId);
        return new Command<List<Map<String, Object>>>("LayerTree.snapshotCommandLog", params.build(), ConverterFunctions.map("commandLog", new TypeToken<List<Map<String, Object>>>(){}.getType()));
    }

    public static Event<LayerPainted> layerPainted() {
        return new Event<LayerPainted>("LayerTree.layerPainted", input -> (LayerPainted)input.read((Type)((Object)LayerPainted.class)));
    }

    public static Event<List<Layer>> layerTreeDidChange() {
        return new Event<List<Layer>>("LayerTree.layerTreeDidChange", ConverterFunctions.map("layers", new TypeToken<List<Layer>>(){}.getType()));
    }

    public static class CompositingReasonsResponse {
        private final List<String> compositingReasons;
        private final List<String> compositingReasonIds;

        public CompositingReasonsResponse(List<String> compositingReasons, List<String> compositingReasonIds) {
            this.compositingReasons = Objects.requireNonNull(compositingReasons, "compositingReasons is required");
            this.compositingReasonIds = Objects.requireNonNull(compositingReasonIds, "compositingReasonIds is required");
        }

        public List<String> getCompositingReasons() {
            return this.compositingReasons;
        }

        public List<String> getCompositingReasonIds() {
            return this.compositingReasonIds;
        }

        private static CompositingReasonsResponse fromJson(JsonInput input) {
            List compositingReasons = null;
            List compositingReasonIds = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "compositingReasons": {
                        compositingReasons = (List)input.read(new TypeToken<List<String>>(){}.getType());
                        continue block8;
                    }
                    case "compositingReasonIds": {
                        compositingReasonIds = (List)input.read(new TypeToken<List<String>>(){}.getType());
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CompositingReasonsResponse(compositingReasons, compositingReasonIds);
        }
    }
}

