/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.profiler;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v112.profiler.model.ConsoleProfileFinished;
import org.openqa.selenium.devtools.v112.profiler.model.ConsoleProfileStarted;
import org.openqa.selenium.devtools.v112.profiler.model.PreciseCoverageDeltaUpdate;
import org.openqa.selenium.devtools.v112.profiler.model.Profile;
import org.openqa.selenium.devtools.v112.profiler.model.ScriptCoverage;
import org.openqa.selenium.json.JsonInput;

public class Profiler {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.enable", params.build());
    }

    public static Command<List<ScriptCoverage>> getBestEffortCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<ScriptCoverage>>("Profiler.getBestEffortCoverage", params.build(), ConverterFunctions.map("result", new TypeToken<List<ScriptCoverage>>(){}.getType()));
    }

    public static Command<Void> setSamplingInterval(Integer interval) {
        Objects.requireNonNull(interval, "interval is required");
        ImmutableMap.Builder<String, Integer> params = ImmutableMap.builder();
        params.put("interval", interval);
        return new Command<Void>("Profiler.setSamplingInterval", params.build());
    }

    public static Command<Void> start() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.start", params.build());
    }

    public static Command<Number> startPreciseCoverage(Optional<Boolean> callCount, Optional<Boolean> detailed, Optional<Boolean> allowTriggeredUpdates) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        callCount.ifPresent(p -> params.put("callCount", p));
        detailed.ifPresent(p -> params.put("detailed", p));
        allowTriggeredUpdates.ifPresent(p -> params.put("allowTriggeredUpdates", p));
        return new Command<Number>("Profiler.startPreciseCoverage", params.build(), ConverterFunctions.map("timestamp", Number.class));
    }

    public static Command<Profile> stop() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Profile>("Profiler.stop", params.build(), ConverterFunctions.map("profile", Profile.class));
    }

    public static Command<Void> stopPreciseCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Profiler.stopPreciseCoverage", params.build());
    }

    public static Command<TakePreciseCoverageResponse> takePreciseCoverage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<TakePreciseCoverageResponse>("Profiler.takePreciseCoverage", params.build(), input -> (TakePreciseCoverageResponse)input.read((Type)((Object)TakePreciseCoverageResponse.class)));
    }

    public static Event<ConsoleProfileFinished> consoleProfileFinished() {
        return new Event<ConsoleProfileFinished>("Profiler.consoleProfileFinished", input -> (ConsoleProfileFinished)input.read((Type)((Object)ConsoleProfileFinished.class)));
    }

    public static Event<ConsoleProfileStarted> consoleProfileStarted() {
        return new Event<ConsoleProfileStarted>("Profiler.consoleProfileStarted", input -> (ConsoleProfileStarted)input.read((Type)((Object)ConsoleProfileStarted.class)));
    }

    public static Event<PreciseCoverageDeltaUpdate> preciseCoverageDeltaUpdate() {
        return new Event<PreciseCoverageDeltaUpdate>("Profiler.preciseCoverageDeltaUpdate", input -> (PreciseCoverageDeltaUpdate)input.read((Type)((Object)PreciseCoverageDeltaUpdate.class)));
    }

    public static class TakePreciseCoverageResponse {
        private final List<ScriptCoverage> result;
        private final Number timestamp;

        public TakePreciseCoverageResponse(List<ScriptCoverage> result, Number timestamp) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        }

        public List<ScriptCoverage> getResult() {
            return this.result;
        }

        public Number getTimestamp() {
            return this.timestamp;
        }

        private static TakePreciseCoverageResponse fromJson(JsonInput input) {
            List result = null;
            Number timestamp = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (List)input.read(new TypeToken<List<ScriptCoverage>>(){}.getType());
                        continue block8;
                    }
                    case "timestamp": {
                        timestamp = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new TakePreciseCoverageResponse(result, timestamp);
        }
    }
}

