/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.css.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v113.css.model.CSSContainerQuery;
import org.openqa.selenium.devtools.v113.css.model.CSSLayer;
import org.openqa.selenium.devtools.v113.css.model.CSSMedia;
import org.openqa.selenium.devtools.v113.css.model.CSSScope;
import org.openqa.selenium.devtools.v113.css.model.CSSStyle;
import org.openqa.selenium.devtools.v113.css.model.CSSSupports;
import org.openqa.selenium.devtools.v113.css.model.SelectorList;
import org.openqa.selenium.devtools.v113.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v113.css.model.StyleSheetOrigin;
import org.openqa.selenium.json.JsonInput;

public class CSSRule {
    private final Optional<StyleSheetId> styleSheetId;
    private final SelectorList selectorList;
    private final Optional<List<String>> nestingSelectors;
    private final StyleSheetOrigin origin;
    private final CSSStyle style;
    private final Optional<List<CSSMedia>> media;
    private final Optional<List<CSSContainerQuery>> containerQueries;
    private final Optional<List<CSSSupports>> supports;
    private final Optional<List<CSSLayer>> layers;
    private final Optional<List<CSSScope>> scopes;

    public CSSRule(Optional<StyleSheetId> styleSheetId, SelectorList selectorList, Optional<List<String>> nestingSelectors, StyleSheetOrigin origin, CSSStyle style, Optional<List<CSSMedia>> media, Optional<List<CSSContainerQuery>> containerQueries, Optional<List<CSSSupports>> supports, Optional<List<CSSLayer>> layers, Optional<List<CSSScope>> scopes) {
        this.styleSheetId = styleSheetId;
        this.selectorList = Objects.requireNonNull(selectorList, "selectorList is required");
        this.nestingSelectors = nestingSelectors;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.style = Objects.requireNonNull(style, "style is required");
        this.media = media;
        this.containerQueries = containerQueries;
        this.supports = supports;
        this.layers = layers;
        this.scopes = scopes;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Beta
    public Optional<List<String>> getNestingSelectors() {
        return this.nestingSelectors;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    public Optional<List<CSSMedia>> getMedia() {
        return this.media;
    }

    @Beta
    public Optional<List<CSSContainerQuery>> getContainerQueries() {
        return this.containerQueries;
    }

    @Beta
    public Optional<List<CSSSupports>> getSupports() {
        return this.supports;
    }

    @Beta
    public Optional<List<CSSLayer>> getLayers() {
        return this.layers;
    }

    @Beta
    public Optional<List<CSSScope>> getScopes() {
        return this.scopes;
    }

    private static CSSRule fromJson(JsonInput input) {
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        SelectorList selectorList = null;
        Optional<List<String>> nestingSelectors = Optional.empty();
        StyleSheetOrigin origin = null;
        CSSStyle style = null;
        Optional<List<CSSMedia>> media = Optional.empty();
        Optional<List<CSSContainerQuery>> containerQueries = Optional.empty();
        Optional<List<CSSSupports>> supports = Optional.empty();
        Optional<List<CSSLayer>> layers = Optional.empty();
        Optional<List<CSSScope>> scopes = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read((Type)((Object)StyleSheetId.class)));
                    continue block24;
                }
                case "selectorList": {
                    selectorList = (SelectorList)input.read((Type)((Object)SelectorList.class));
                    continue block24;
                }
                case "nestingSelectors": {
                    nestingSelectors = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                    continue block24;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read((Type)((Object)StyleSheetOrigin.class)));
                    continue block24;
                }
                case "style": {
                    style = (CSSStyle)input.read((Type)((Object)CSSStyle.class));
                    continue block24;
                }
                case "media": {
                    media = Optional.ofNullable((List)input.read(new TypeToken<List<CSSMedia>>(){}.getType()));
                    continue block24;
                }
                case "containerQueries": {
                    containerQueries = Optional.ofNullable((List)input.read(new TypeToken<List<CSSContainerQuery>>(){}.getType()));
                    continue block24;
                }
                case "supports": {
                    supports = Optional.ofNullable((List)input.read(new TypeToken<List<CSSSupports>>(){}.getType()));
                    continue block24;
                }
                case "layers": {
                    layers = Optional.ofNullable((List)input.read(new TypeToken<List<CSSLayer>>(){}.getType()));
                    continue block24;
                }
                case "scopes": {
                    scopes = Optional.ofNullable((List)input.read(new TypeToken<List<CSSScope>>(){}.getType()));
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSRule(styleSheetId, selectorList, nestingSelectors, origin, style, media, containerQueries, supports, layers, scopes);
    }
}

