/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.database;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v113.database.model.DatabaseId;
import org.openqa.selenium.devtools.v113.database.model.Error;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Database {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Database.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Database.enable", params.build());
    }

    public static Command<ExecuteSQLResponse> executeSQL(DatabaseId databaseId, String query) {
        Objects.requireNonNull(databaseId, "databaseId is required");
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("databaseId", databaseId);
        params.put("query", query);
        return new Command<ExecuteSQLResponse>("Database.executeSQL", params.build(), input -> (ExecuteSQLResponse)input.read((Type)((Object)ExecuteSQLResponse.class)));
    }

    public static Command<List<String>> getDatabaseTableNames(DatabaseId databaseId) {
        Objects.requireNonNull(databaseId, "databaseId is required");
        ImmutableMap.Builder<String, DatabaseId> params = ImmutableMap.builder();
        params.put("databaseId", databaseId);
        return new Command<List<String>>("Database.getDatabaseTableNames", params.build(), ConverterFunctions.map("tableNames", new TypeToken<List<String>>(){}.getType()));
    }

    public static Event<org.openqa.selenium.devtools.v113.database.model.Database> addDatabase() {
        return new Event<org.openqa.selenium.devtools.v113.database.model.Database>("Database.addDatabase", ConverterFunctions.map("database", org.openqa.selenium.devtools.v113.database.model.Database.class));
    }

    public static class ExecuteSQLResponse {
        private final Optional<List<String>> columnNames;
        private final Optional<List<Object>> values;
        private final Optional<Error> sqlError;

        public ExecuteSQLResponse(Optional<List<String>> columnNames, Optional<List<Object>> values2, Optional<Error> sqlError) {
            this.columnNames = columnNames;
            this.values = values2;
            this.sqlError = sqlError;
        }

        public Optional<List<String>> getColumnNames() {
            return this.columnNames;
        }

        public Optional<List<Object>> getValues() {
            return this.values;
        }

        public Optional<Error> getSqlError() {
            return this.sqlError;
        }

        private static ExecuteSQLResponse fromJson(JsonInput input) {
            Optional<List<String>> columnNames = Optional.empty();
            Optional<List<Object>> values2 = Optional.empty();
            Optional<Error> sqlError = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "columnNames": {
                        columnNames = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                        continue block10;
                    }
                    case "values": {
                        values2 = Optional.ofNullable((List)input.read(new TypeToken<List<Object>>(){}.getType()));
                        continue block10;
                    }
                    case "sqlError": {
                        sqlError = Optional.ofNullable((Error)input.read((Type)((Object)Error.class)));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new ExecuteSQLResponse(columnNames, values2, sqlError);
        }
    }
}

