/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.domstorage;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v113.domstorage.model.DomStorageItemAdded;
import org.openqa.selenium.devtools.v113.domstorage.model.DomStorageItemRemoved;
import org.openqa.selenium.devtools.v113.domstorage.model.DomStorageItemUpdated;
import org.openqa.selenium.devtools.v113.domstorage.model.Item;
import org.openqa.selenium.devtools.v113.domstorage.model.StorageId;

@Beta
public class DOMStorage {
    public static Command<Void> clear(StorageId storageId) {
        Objects.requireNonNull(storageId, "storageId is required");
        ImmutableMap.Builder<String, StorageId> params = ImmutableMap.builder();
        params.put("storageId", storageId);
        return new Command<Void>("DOMStorage.clear", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOMStorage.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOMStorage.enable", params.build());
    }

    public static Command<List<Item>> getDOMStorageItems(StorageId storageId) {
        Objects.requireNonNull(storageId, "storageId is required");
        ImmutableMap.Builder<String, StorageId> params = ImmutableMap.builder();
        params.put("storageId", storageId);
        return new Command<List<Item>>("DOMStorage.getDOMStorageItems", params.build(), ConverterFunctions.map("entries", new TypeToken<List<Item>>(){}.getType()));
    }

    public static Command<Void> removeDOMStorageItem(StorageId storageId, String key) {
        Objects.requireNonNull(storageId, "storageId is required");
        Objects.requireNonNull(key, "key is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("storageId", storageId);
        params.put("key", key);
        return new Command<Void>("DOMStorage.removeDOMStorageItem", params.build());
    }

    public static Command<Void> setDOMStorageItem(StorageId storageId, String key, String value) {
        Objects.requireNonNull(storageId, "storageId is required");
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("storageId", storageId);
        params.put("key", key);
        params.put("value", value);
        return new Command<Void>("DOMStorage.setDOMStorageItem", params.build());
    }

    public static Event<DomStorageItemAdded> domStorageItemAdded() {
        return new Event<DomStorageItemAdded>("DOMStorage.domStorageItemAdded", input -> (DomStorageItemAdded)input.read((Type)((Object)DomStorageItemAdded.class)));
    }

    public static Event<DomStorageItemRemoved> domStorageItemRemoved() {
        return new Event<DomStorageItemRemoved>("DOMStorage.domStorageItemRemoved", input -> (DomStorageItemRemoved)input.read((Type)((Object)DomStorageItemRemoved.class)));
    }

    public static Event<DomStorageItemUpdated> domStorageItemUpdated() {
        return new Event<DomStorageItemUpdated>("DOMStorage.domStorageItemUpdated", input -> (DomStorageItemUpdated)input.read((Type)((Object)DomStorageItemUpdated.class)));
    }

    public static Event<StorageId> domStorageItemsCleared() {
        return new Event<StorageId>("DOMStorage.domStorageItemsCleared", ConverterFunctions.map("storageId", StorageId.class));
    }
}

