/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.audits.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v114.audits.model.TwaQualityEnforcementViolationType;
import org.openqa.selenium.json.JsonInput;

public class TrustedWebActivityIssueDetails {
    private final String url;
    private final TwaQualityEnforcementViolationType violationType;
    private final Optional<Integer> httpStatusCode;
    private final Optional<String> packageName;
    private final Optional<String> signature;

    public TrustedWebActivityIssueDetails(String url, TwaQualityEnforcementViolationType violationType, Optional<Integer> httpStatusCode, Optional<String> packageName, Optional<String> signature) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.violationType = Objects.requireNonNull(violationType, "violationType is required");
        this.httpStatusCode = httpStatusCode;
        this.packageName = packageName;
        this.signature = signature;
    }

    public String getUrl() {
        return this.url;
    }

    public TwaQualityEnforcementViolationType getViolationType() {
        return this.violationType;
    }

    public Optional<Integer> getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public Optional<String> getPackageName() {
        return this.packageName;
    }

    public Optional<String> getSignature() {
        return this.signature;
    }

    private static TrustedWebActivityIssueDetails fromJson(JsonInput input) {
        String url = null;
        TwaQualityEnforcementViolationType violationType = null;
        Optional<Integer> httpStatusCode = Optional.empty();
        Optional<String> packageName = Optional.empty();
        Optional<String> signature = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block14;
                }
                case "violationType": {
                    violationType = (TwaQualityEnforcementViolationType)((Object)input.read((Type)((Object)TwaQualityEnforcementViolationType.class)));
                    continue block14;
                }
                case "httpStatusCode": {
                    httpStatusCode = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
                case "packageName": {
                    packageName = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "signature": {
                    signature = Optional.ofNullable(input.nextString());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TrustedWebActivityIssueDetails(url, violationType, httpStatusCode, packageName, signature);
    }
}

