/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.browser;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v114.browser.model.Bounds;
import org.openqa.selenium.devtools.v114.browser.model.BrowserCommandId;
import org.openqa.selenium.devtools.v114.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v114.browser.model.DownloadProgress;
import org.openqa.selenium.devtools.v114.browser.model.DownloadWillBegin;
import org.openqa.selenium.devtools.v114.browser.model.Histogram;
import org.openqa.selenium.devtools.v114.browser.model.PermissionDescriptor;
import org.openqa.selenium.devtools.v114.browser.model.PermissionSetting;
import org.openqa.selenium.devtools.v114.browser.model.PermissionType;
import org.openqa.selenium.devtools.v114.browser.model.WindowID;
import org.openqa.selenium.devtools.v114.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class Browser {
    @Beta
    public static Command<Void> setPermission(PermissionDescriptor permission, PermissionSetting setting, Optional<String> origin, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(permission, "permission is required");
        Objects.requireNonNull(setting, "setting is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("permission", permission);
        params.put("setting", (Object)setting);
        origin.ifPresent(p -> params.put("origin", p));
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<Void>("Browser.setPermission", params.build());
    }

    @Beta
    public static Command<Void> grantPermissions(List<PermissionType> permissions, Optional<String> origin, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(permissions, "permissions is required");
        ImmutableMap.Builder<String, List<PermissionType>> params = ImmutableMap.builder();
        params.put("permissions", permissions);
        origin.ifPresent(p -> params.put("origin", (List<PermissionType>)p));
        browserContextId.ifPresent(p -> params.put("browserContextId", (List<PermissionType>)p));
        return new Command<Void>("Browser.grantPermissions", params.build());
    }

    @Beta
    public static Command<Void> resetPermissions(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<Void>("Browser.resetPermissions", params.build());
    }

    @Beta
    public static Command<Void> setDownloadBehavior(SetDownloadBehaviorBehavior behavior, Optional<BrowserContextID> browserContextId, Optional<String> downloadPath, Optional<Boolean> eventsEnabled) {
        Objects.requireNonNull(behavior, "behavior is required");
        ImmutableMap.Builder<String, SetDownloadBehaviorBehavior> params = ImmutableMap.builder();
        params.put("behavior", behavior);
        browserContextId.ifPresent(p -> params.put("browserContextId", (SetDownloadBehaviorBehavior)((Object)p)));
        downloadPath.ifPresent(p -> params.put("downloadPath", (SetDownloadBehaviorBehavior)((Object)p)));
        eventsEnabled.ifPresent(p -> params.put("eventsEnabled", (SetDownloadBehaviorBehavior)((Object)p)));
        return new Command<Void>("Browser.setDownloadBehavior", params.build());
    }

    @Beta
    public static Command<Void> cancelDownload(String guid, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(guid, "guid is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("guid", guid);
        browserContextId.ifPresent(p -> params.put("browserContextId", (String)p));
        return new Command<Void>("Browser.cancelDownload", params.build());
    }

    public static Command<Void> close() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Browser.close", params.build());
    }

    @Beta
    public static Command<Void> crash() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Browser.crash", params.build());
    }

    @Beta
    public static Command<Void> crashGpuProcess() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Browser.crashGpuProcess", params.build());
    }

    public static Command<GetVersionResponse> getVersion() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<GetVersionResponse>("Browser.getVersion", params.build(), input -> (GetVersionResponse)input.read((Type)((Object)GetVersionResponse.class)));
    }

    @Beta
    public static Command<List<String>> getBrowserCommandLine() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<String>>("Browser.getBrowserCommandLine", params.build(), ConverterFunctions.map("arguments", new TypeToken<List<String>>(){}.getType()));
    }

    @Beta
    public static Command<List<Histogram>> getHistograms(Optional<String> query, Optional<Boolean> delta) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        query.ifPresent(p -> params.put("query", p));
        delta.ifPresent(p -> params.put("delta", p));
        return new Command<List<Histogram>>("Browser.getHistograms", params.build(), ConverterFunctions.map("histograms", new TypeToken<List<Histogram>>(){}.getType()));
    }

    @Beta
    public static Command<Histogram> getHistogram(String name2, Optional<Boolean> delta) {
        Objects.requireNonNull(name2, "name is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("name", name2);
        delta.ifPresent(p -> params.put("delta", (String)p));
        return new Command<Histogram>("Browser.getHistogram", params.build(), ConverterFunctions.map("histogram", Histogram.class));
    }

    @Beta
    public static Command<Bounds> getWindowBounds(WindowID windowId) {
        Objects.requireNonNull(windowId, "windowId is required");
        ImmutableMap.Builder<String, WindowID> params = ImmutableMap.builder();
        params.put("windowId", windowId);
        return new Command<Bounds>("Browser.getWindowBounds", params.build(), ConverterFunctions.map("bounds", Bounds.class));
    }

    @Beta
    public static Command<GetWindowForTargetResponse> getWindowForTarget(Optional<TargetID> targetId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command<GetWindowForTargetResponse>("Browser.getWindowForTarget", params.build(), input -> (GetWindowForTargetResponse)input.read((Type)((Object)GetWindowForTargetResponse.class)));
    }

    @Beta
    public static Command<Void> setWindowBounds(WindowID windowId, Bounds bounds) {
        Objects.requireNonNull(windowId, "windowId is required");
        Objects.requireNonNull(bounds, "bounds is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("windowId", windowId);
        params.put("bounds", bounds);
        return new Command<Void>("Browser.setWindowBounds", params.build());
    }

    @Beta
    public static Command<Void> setDockTile(Optional<String> badgeLabel, Optional<String> image) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        badgeLabel.ifPresent(p -> params.put("badgeLabel", p));
        image.ifPresent(p -> params.put("image", p));
        return new Command<Void>("Browser.setDockTile", params.build());
    }

    @Beta
    public static Command<Void> executeBrowserCommand(BrowserCommandId commandId) {
        Objects.requireNonNull(commandId, "commandId is required");
        ImmutableMap.Builder<String, BrowserCommandId> params = ImmutableMap.builder();
        params.put("commandId", commandId);
        return new Command<Void>("Browser.executeBrowserCommand", params.build());
    }

    public static Event<DownloadWillBegin> downloadWillBegin() {
        return new Event<DownloadWillBegin>("Browser.downloadWillBegin", input -> (DownloadWillBegin)input.read((Type)((Object)DownloadWillBegin.class)));
    }

    public static Event<DownloadProgress> downloadProgress() {
        return new Event<DownloadProgress>("Browser.downloadProgress", input -> (DownloadProgress)input.read((Type)((Object)DownloadProgress.class)));
    }

    public static class GetWindowForTargetResponse {
        private final WindowID windowId;
        private final Bounds bounds;

        public GetWindowForTargetResponse(WindowID windowId, Bounds bounds) {
            this.windowId = Objects.requireNonNull(windowId, "windowId is required");
            this.bounds = Objects.requireNonNull(bounds, "bounds is required");
        }

        public WindowID getWindowId() {
            return this.windowId;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        private static GetWindowForTargetResponse fromJson(JsonInput input) {
            WindowID windowId = null;
            Bounds bounds = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "windowId": {
                        windowId = (WindowID)input.read((Type)((Object)WindowID.class));
                        continue block8;
                    }
                    case "bounds": {
                        bounds = (Bounds)input.read((Type)((Object)Bounds.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetWindowForTargetResponse(windowId, bounds);
        }
    }

    public static class GetVersionResponse {
        private final String protocolVersion;
        private final String product;
        private final String revision;
        private final String userAgent;
        private final String jsVersion;

        public GetVersionResponse(String protocolVersion, String product2, String revision, String userAgent, String jsVersion) {
            this.protocolVersion = Objects.requireNonNull(protocolVersion, "protocolVersion is required");
            this.product = Objects.requireNonNull(product2, "product is required");
            this.revision = Objects.requireNonNull(revision, "revision is required");
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent is required");
            this.jsVersion = Objects.requireNonNull(jsVersion, "jsVersion is required");
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        public String getProduct() {
            return this.product;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getJsVersion() {
            return this.jsVersion;
        }

        private static GetVersionResponse fromJson(JsonInput input) {
            String protocolVersion = null;
            String product2 = null;
            String revision = null;
            String userAgent = null;
            String jsVersion = null;
            input.beginObject();
            block14: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "protocolVersion": {
                        protocolVersion = input.nextString();
                        continue block14;
                    }
                    case "product": {
                        product2 = input.nextString();
                        continue block14;
                    }
                    case "revision": {
                        revision = input.nextString();
                        continue block14;
                    }
                    case "userAgent": {
                        userAgent = input.nextString();
                        continue block14;
                    }
                    case "jsVersion": {
                        jsVersion = input.nextString();
                        continue block14;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetVersionResponse(protocolVersion, product2, revision, userAgent, jsVersion);
        }
    }

    public static enum SetDownloadBehaviorBehavior {
        DENY("deny"),
        ALLOW("allow"),
        ALLOWANDNAME("allowAndName"),
        DEFAULT("default");

        private String value;

        private SetDownloadBehaviorBehavior(String value) {
            this.value = value;
        }

        public static SetDownloadBehaviorBehavior fromString(String s) {
            return Arrays.stream(SetDownloadBehaviorBehavior.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetDownloadBehaviorBehavior "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetDownloadBehaviorBehavior fromJson(JsonInput input) {
            return SetDownloadBehaviorBehavior.fromString(input.nextString());
        }
    }
}

