/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.deviceaccess;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v114.deviceaccess.model.DeviceId;
import org.openqa.selenium.devtools.v114.deviceaccess.model.DeviceRequestPrompted;
import org.openqa.selenium.devtools.v114.deviceaccess.model.RequestId;

@Beta
public class DeviceAccess {
    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DeviceAccess.enable", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DeviceAccess.disable", params.build());
    }

    public static Command<Void> selectPrompt(RequestId id, DeviceId deviceId) {
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(deviceId, "deviceId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("id", id);
        params.put("deviceId", deviceId);
        return new Command<Void>("DeviceAccess.selectPrompt", params.build());
    }

    public static Command<Void> cancelPrompt(RequestId id) {
        Objects.requireNonNull(id, "id is required");
        ImmutableMap.Builder<String, RequestId> params = ImmutableMap.builder();
        params.put("id", id);
        return new Command<Void>("DeviceAccess.cancelPrompt", params.build());
    }

    public static Event<DeviceRequestPrompted> deviceRequestPrompted() {
        return new Event<DeviceRequestPrompted>("DeviceAccess.deviceRequestPrompted", input -> (DeviceRequestPrompted)input.read((Type)((Object)DeviceRequestPrompted.class)));
    }
}

