/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.runtime;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v114.runtime.model.BindingCalled;
import org.openqa.selenium.devtools.v114.runtime.model.CallArgument;
import org.openqa.selenium.devtools.v114.runtime.model.ConsoleAPICalled;
import org.openqa.selenium.devtools.v114.runtime.model.ExceptionDetails;
import org.openqa.selenium.devtools.v114.runtime.model.ExceptionRevoked;
import org.openqa.selenium.devtools.v114.runtime.model.ExceptionThrown;
import org.openqa.selenium.devtools.v114.runtime.model.ExecutionContextDescription;
import org.openqa.selenium.devtools.v114.runtime.model.ExecutionContextDestroyed;
import org.openqa.selenium.devtools.v114.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v114.runtime.model.InspectRequested;
import org.openqa.selenium.devtools.v114.runtime.model.InternalPropertyDescriptor;
import org.openqa.selenium.devtools.v114.runtime.model.PrivatePropertyDescriptor;
import org.openqa.selenium.devtools.v114.runtime.model.PropertyDescriptor;
import org.openqa.selenium.devtools.v114.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v114.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v114.runtime.model.ScriptId;
import org.openqa.selenium.devtools.v114.runtime.model.TimeDelta;
import org.openqa.selenium.json.JsonInput;

public class Runtime {
    public static Command<AwaitPromiseResponse> awaitPromise(RemoteObjectId promiseObjectId, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview) {
        Objects.requireNonNull(promiseObjectId, "promiseObjectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("promiseObjectId", promiseObjectId);
        returnByValue.ifPresent(p -> params.put("returnByValue", (RemoteObjectId)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (RemoteObjectId)p));
        return new Command<AwaitPromiseResponse>("Runtime.awaitPromise", params.build(), input -> (AwaitPromiseResponse)input.read((Type)((Object)AwaitPromiseResponse.class)));
    }

    public static Command<CallFunctionOnResponse> callFunctionOn(String functionDeclaration, Optional<RemoteObjectId> objectId, Optional<List<CallArgument>> arguments, Optional<Boolean> silent, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> userGesture, Optional<Boolean> awaitPromise, Optional<ExecutionContextId> executionContextId, Optional<String> objectGroup, Optional<Boolean> throwOnSideEffect, Optional<String> uniqueContextId, Optional<Boolean> generateWebDriverValue) {
        Objects.requireNonNull(functionDeclaration, "functionDeclaration is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("functionDeclaration", functionDeclaration);
        objectId.ifPresent(p -> params.put("objectId", (String)p));
        arguments.ifPresent(p -> params.put("arguments", (String)p));
        silent.ifPresent(p -> params.put("silent", (String)p));
        returnByValue.ifPresent(p -> params.put("returnByValue", (String)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (String)p));
        userGesture.ifPresent(p -> params.put("userGesture", (String)p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", (String)p));
        executionContextId.ifPresent(p -> params.put("executionContextId", (String)p));
        objectGroup.ifPresent(p -> params.put("objectGroup", (String)p));
        throwOnSideEffect.ifPresent(p -> params.put("throwOnSideEffect", (String)p));
        uniqueContextId.ifPresent(p -> params.put("uniqueContextId", (String)p));
        generateWebDriverValue.ifPresent(p -> params.put("generateWebDriverValue", (String)p));
        return new Command<CallFunctionOnResponse>("Runtime.callFunctionOn", params.build(), input -> (CallFunctionOnResponse)input.read((Type)((Object)CallFunctionOnResponse.class)));
    }

    public static Command<CompileScriptResponse> compileScript(String expression, String sourceURL, Boolean persistScript, Optional<ExecutionContextId> executionContextId) {
        Objects.requireNonNull(expression, "expression is required");
        Objects.requireNonNull(sourceURL, "sourceURL is required");
        Objects.requireNonNull(persistScript, "persistScript is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("expression", expression);
        params.put("sourceURL", sourceURL);
        params.put("persistScript", persistScript);
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        return new Command<CompileScriptResponse>("Runtime.compileScript", params.build(), input -> (CompileScriptResponse)input.read((Type)((Object)CompileScriptResponse.class)));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.disable", params.build());
    }

    public static Command<Void> discardConsoleEntries() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.discardConsoleEntries", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.enable", params.build());
    }

    public static Command<EvaluateResponse> evaluate(String expression, Optional<String> objectGroup, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> silent, Optional<ExecutionContextId> contextId, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> userGesture, Optional<Boolean> awaitPromise, Optional<Boolean> throwOnSideEffect, Optional<TimeDelta> timeout2, Optional<Boolean> disableBreaks, Optional<Boolean> replMode, Optional<Boolean> allowUnsafeEvalBlockedByCSP, Optional<String> uniqueContextId, Optional<Boolean> generateWebDriverValue) {
        Objects.requireNonNull(expression, "expression is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("expression", expression);
        objectGroup.ifPresent(p -> params.put("objectGroup", (String)p));
        includeCommandLineAPI.ifPresent(p -> params.put("includeCommandLineAPI", (String)p));
        silent.ifPresent(p -> params.put("silent", (String)p));
        contextId.ifPresent(p -> params.put("contextId", (String)p));
        returnByValue.ifPresent(p -> params.put("returnByValue", (String)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (String)p));
        userGesture.ifPresent(p -> params.put("userGesture", (String)p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", (String)p));
        throwOnSideEffect.ifPresent(p -> params.put("throwOnSideEffect", (String)p));
        timeout2.ifPresent(p -> params.put("timeout", (String)p));
        disableBreaks.ifPresent(p -> params.put("disableBreaks", (String)p));
        replMode.ifPresent(p -> params.put("replMode", (String)p));
        allowUnsafeEvalBlockedByCSP.ifPresent(p -> params.put("allowUnsafeEvalBlockedByCSP", (String)p));
        uniqueContextId.ifPresent(p -> params.put("uniqueContextId", (String)p));
        generateWebDriverValue.ifPresent(p -> params.put("generateWebDriverValue", (String)p));
        return new Command<EvaluateResponse>("Runtime.evaluate", params.build(), input -> (EvaluateResponse)input.read((Type)((Object)EvaluateResponse.class)));
    }

    @Beta
    public static Command<String> getIsolateId() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<String>("Runtime.getIsolateId", params.build(), ConverterFunctions.map("id", String.class));
    }

    @Beta
    public static Command<GetHeapUsageResponse> getHeapUsage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<GetHeapUsageResponse>("Runtime.getHeapUsage", params.build(), input -> (GetHeapUsageResponse)input.read((Type)((Object)GetHeapUsageResponse.class)));
    }

    public static Command<GetPropertiesResponse> getProperties(RemoteObjectId objectId, Optional<Boolean> ownProperties, Optional<Boolean> accessorPropertiesOnly, Optional<Boolean> generatePreview, Optional<Boolean> nonIndexedPropertiesOnly) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("objectId", objectId);
        ownProperties.ifPresent(p -> params.put("ownProperties", (RemoteObjectId)p));
        accessorPropertiesOnly.ifPresent(p -> params.put("accessorPropertiesOnly", (RemoteObjectId)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (RemoteObjectId)p));
        nonIndexedPropertiesOnly.ifPresent(p -> params.put("nonIndexedPropertiesOnly", (RemoteObjectId)p));
        return new Command<GetPropertiesResponse>("Runtime.getProperties", params.build(), input -> (GetPropertiesResponse)input.read((Type)((Object)GetPropertiesResponse.class)));
    }

    public static Command<List<String>> globalLexicalScopeNames(Optional<ExecutionContextId> executionContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        return new Command<List<String>>("Runtime.globalLexicalScopeNames", params.build(), ConverterFunctions.map("names", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<RemoteObject> queryObjects(RemoteObjectId prototypeObjectId, Optional<String> objectGroup) {
        Objects.requireNonNull(prototypeObjectId, "prototypeObjectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("prototypeObjectId", prototypeObjectId);
        objectGroup.ifPresent(p -> params.put("objectGroup", (RemoteObjectId)p));
        return new Command<RemoteObject>("Runtime.queryObjects", params.build(), ConverterFunctions.map("objects", RemoteObject.class));
    }

    public static Command<Void> releaseObject(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("objectId", objectId);
        return new Command<Void>("Runtime.releaseObject", params.build());
    }

    public static Command<Void> releaseObjectGroup(String objectGroup) {
        Objects.requireNonNull(objectGroup, "objectGroup is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("objectGroup", objectGroup);
        return new Command<Void>("Runtime.releaseObjectGroup", params.build());
    }

    public static Command<Void> runIfWaitingForDebugger() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.runIfWaitingForDebugger", params.build());
    }

    public static Command<RunScriptResponse> runScript(ScriptId scriptId, Optional<ExecutionContextId> executionContextId, Optional<String> objectGroup, Optional<Boolean> silent, Optional<Boolean> includeCommandLineAPI, Optional<Boolean> returnByValue, Optional<Boolean> generatePreview, Optional<Boolean> awaitPromise) {
        Objects.requireNonNull(scriptId, "scriptId is required");
        ImmutableMap.Builder<String, ScriptId> params = ImmutableMap.builder();
        params.put("scriptId", scriptId);
        executionContextId.ifPresent(p -> params.put("executionContextId", (ScriptId)p));
        objectGroup.ifPresent(p -> params.put("objectGroup", (ScriptId)p));
        silent.ifPresent(p -> params.put("silent", (ScriptId)p));
        includeCommandLineAPI.ifPresent(p -> params.put("includeCommandLineAPI", (ScriptId)p));
        returnByValue.ifPresent(p -> params.put("returnByValue", (ScriptId)p));
        generatePreview.ifPresent(p -> params.put("generatePreview", (ScriptId)p));
        awaitPromise.ifPresent(p -> params.put("awaitPromise", (ScriptId)p));
        return new Command<RunScriptResponse>("Runtime.runScript", params.build(), input -> (RunScriptResponse)input.read((Type)((Object)RunScriptResponse.class)));
    }

    public static Command<Void> setAsyncCallStackDepth(Integer maxDepth) {
        Objects.requireNonNull(maxDepth, "maxDepth is required");
        ImmutableMap.Builder<String, Integer> params = ImmutableMap.builder();
        params.put("maxDepth", maxDepth);
        return new Command<Void>("Runtime.setAsyncCallStackDepth", params.build());
    }

    @Beta
    public static Command<Void> setCustomObjectFormatterEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enabled", enabled);
        return new Command<Void>("Runtime.setCustomObjectFormatterEnabled", params.build());
    }

    @Beta
    public static Command<Void> setMaxCallStackSizeToCapture(Integer size) {
        Objects.requireNonNull(size, "size is required");
        ImmutableMap.Builder<String, Integer> params = ImmutableMap.builder();
        params.put("size", size);
        return new Command<Void>("Runtime.setMaxCallStackSizeToCapture", params.build());
    }

    @Beta
    public static Command<Void> terminateExecution() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Runtime.terminateExecution", params.build());
    }

    @Beta
    public static Command<Void> addBinding(String name2, Optional<ExecutionContextId> executionContextId, Optional<String> executionContextName) {
        Objects.requireNonNull(name2, "name is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("name", name2);
        executionContextId.ifPresent(p -> params.put("executionContextId", (String)p));
        executionContextName.ifPresent(p -> params.put("executionContextName", (String)p));
        return new Command<Void>("Runtime.addBinding", params.build());
    }

    @Beta
    public static Command<Void> removeBinding(String name2) {
        Objects.requireNonNull(name2, "name is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("name", name2);
        return new Command<Void>("Runtime.removeBinding", params.build());
    }

    @Beta
    public static Command<ExceptionDetails> getExceptionDetails(RemoteObjectId errorObjectId) {
        Objects.requireNonNull(errorObjectId, "errorObjectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("errorObjectId", errorObjectId);
        return new Command<ExceptionDetails>("Runtime.getExceptionDetails", params.build(), ConverterFunctions.map("exceptionDetails", ExceptionDetails.class));
    }

    public static Event<BindingCalled> bindingCalled() {
        return new Event<BindingCalled>("Runtime.bindingCalled", input -> (BindingCalled)input.read((Type)((Object)BindingCalled.class)));
    }

    public static Event<ConsoleAPICalled> consoleAPICalled() {
        return new Event<ConsoleAPICalled>("Runtime.consoleAPICalled", input -> (ConsoleAPICalled)input.read((Type)((Object)ConsoleAPICalled.class)));
    }

    public static Event<ExceptionRevoked> exceptionRevoked() {
        return new Event<ExceptionRevoked>("Runtime.exceptionRevoked", input -> (ExceptionRevoked)input.read((Type)((Object)ExceptionRevoked.class)));
    }

    public static Event<ExceptionThrown> exceptionThrown() {
        return new Event<ExceptionThrown>("Runtime.exceptionThrown", input -> (ExceptionThrown)input.read((Type)((Object)ExceptionThrown.class)));
    }

    public static Event<ExecutionContextDescription> executionContextCreated() {
        return new Event<ExecutionContextDescription>("Runtime.executionContextCreated", ConverterFunctions.map("context", ExecutionContextDescription.class));
    }

    public static Event<ExecutionContextDestroyed> executionContextDestroyed() {
        return new Event<ExecutionContextDestroyed>("Runtime.executionContextDestroyed", input -> (ExecutionContextDestroyed)input.read((Type)((Object)ExecutionContextDestroyed.class)));
    }

    public static Event<Void> executionContextsCleared() {
        return new Event<Void>("Runtime.executionContextsCleared", input -> null);
    }

    public static Event<InspectRequested> inspectRequested() {
        return new Event<InspectRequested>("Runtime.inspectRequested", input -> (InspectRequested)input.read((Type)((Object)InspectRequested.class)));
    }

    public static class RunScriptResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public RunScriptResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static RunScriptResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read((Type)((Object)RemoteObject.class));
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read((Type)((Object)ExceptionDetails.class)));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RunScriptResponse(result, exceptionDetails);
        }
    }

    public static class GetPropertiesResponse {
        private final List<PropertyDescriptor> result;
        private final Optional<List<InternalPropertyDescriptor>> internalProperties;
        private final Optional<List<PrivatePropertyDescriptor>> privateProperties;
        private final Optional<ExceptionDetails> exceptionDetails;

        public GetPropertiesResponse(List<PropertyDescriptor> result, Optional<List<InternalPropertyDescriptor>> internalProperties, Optional<List<PrivatePropertyDescriptor>> privateProperties, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.internalProperties = internalProperties;
            this.privateProperties = privateProperties;
            this.exceptionDetails = exceptionDetails;
        }

        public List<PropertyDescriptor> getResult() {
            return this.result;
        }

        public Optional<List<InternalPropertyDescriptor>> getInternalProperties() {
            return this.internalProperties;
        }

        public Optional<List<PrivatePropertyDescriptor>> getPrivateProperties() {
            return this.privateProperties;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static GetPropertiesResponse fromJson(JsonInput input) {
            List result = null;
            Optional<List<InternalPropertyDescriptor>> internalProperties = Optional.empty();
            Optional<List<PrivatePropertyDescriptor>> privateProperties = Optional.empty();
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (List)input.read(new TypeToken<List<PropertyDescriptor>>(){}.getType());
                        continue block12;
                    }
                    case "internalProperties": {
                        internalProperties = Optional.ofNullable((List)input.read(new TypeToken<List<InternalPropertyDescriptor>>(){}.getType()));
                        continue block12;
                    }
                    case "privateProperties": {
                        privateProperties = Optional.ofNullable((List)input.read(new TypeToken<List<PrivatePropertyDescriptor>>(){}.getType()));
                        continue block12;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read((Type)((Object)ExceptionDetails.class)));
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetPropertiesResponse(result, internalProperties, privateProperties, exceptionDetails);
        }
    }

    public static class GetHeapUsageResponse {
        private final Number usedSize;
        private final Number totalSize;

        public GetHeapUsageResponse(Number usedSize, Number totalSize) {
            this.usedSize = Objects.requireNonNull(usedSize, "usedSize is required");
            this.totalSize = Objects.requireNonNull(totalSize, "totalSize is required");
        }

        public Number getUsedSize() {
            return this.usedSize;
        }

        public Number getTotalSize() {
            return this.totalSize;
        }

        private static GetHeapUsageResponse fromJson(JsonInput input) {
            Number usedSize = 0;
            Number totalSize = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usedSize": {
                        usedSize = input.nextNumber();
                        continue block8;
                    }
                    case "totalSize": {
                        totalSize = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetHeapUsageResponse(usedSize, totalSize);
        }
    }

    public static class EvaluateResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public EvaluateResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static EvaluateResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read((Type)((Object)RemoteObject.class));
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read((Type)((Object)ExceptionDetails.class)));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new EvaluateResponse(result, exceptionDetails);
        }
    }

    public static class CompileScriptResponse {
        private final Optional<ScriptId> scriptId;
        private final Optional<ExceptionDetails> exceptionDetails;

        public CompileScriptResponse(Optional<ScriptId> scriptId, Optional<ExceptionDetails> exceptionDetails) {
            this.scriptId = scriptId;
            this.exceptionDetails = exceptionDetails;
        }

        public Optional<ScriptId> getScriptId() {
            return this.scriptId;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static CompileScriptResponse fromJson(JsonInput input) {
            Optional<ScriptId> scriptId = Optional.empty();
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "scriptId": {
                        scriptId = Optional.ofNullable((ScriptId)input.read((Type)((Object)ScriptId.class)));
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read((Type)((Object)ExceptionDetails.class)));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CompileScriptResponse(scriptId, exceptionDetails);
        }
    }

    public static class CallFunctionOnResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public CallFunctionOnResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static CallFunctionOnResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read((Type)((Object)RemoteObject.class));
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read((Type)((Object)ExceptionDetails.class)));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CallFunctionOnResponse(result, exceptionDetails);
        }
    }

    public static class AwaitPromiseResponse {
        private final RemoteObject result;
        private final Optional<ExceptionDetails> exceptionDetails;

        public AwaitPromiseResponse(RemoteObject result, Optional<ExceptionDetails> exceptionDetails) {
            this.result = Objects.requireNonNull(result, "result is required");
            this.exceptionDetails = exceptionDetails;
        }

        public RemoteObject getResult() {
            return this.result;
        }

        public Optional<ExceptionDetails> getExceptionDetails() {
            return this.exceptionDetails;
        }

        private static AwaitPromiseResponse fromJson(JsonInput input) {
            RemoteObject result = null;
            Optional<ExceptionDetails> exceptionDetails = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "result": {
                        result = (RemoteObject)input.read((Type)((Object)RemoteObject.class));
                        continue block8;
                    }
                    case "exceptionDetails": {
                        exceptionDetails = Optional.ofNullable((ExceptionDetails)input.read((Type)((Object)ExceptionDetails.class)));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new AwaitPromiseResponse(result, exceptionDetails);
        }
    }
}

