/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.storage.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v114.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v114.storage.model.SerializedStorageKey;
import org.openqa.selenium.devtools.v114.storage.model.StorageBucketsDurability;
import org.openqa.selenium.json.JsonInput;

public class StorageBucketInfo {
    private final SerializedStorageKey storageKey;
    private final String id;
    private final String name;
    private final Boolean isDefault;
    private final TimeSinceEpoch expiration;
    private final Number quota;
    private final Boolean persistent;
    private final StorageBucketsDurability durability;

    public StorageBucketInfo(SerializedStorageKey storageKey, String id, String name2, Boolean isDefault, TimeSinceEpoch expiration, Number quota, Boolean persistent, StorageBucketsDurability durability) {
        this.storageKey = Objects.requireNonNull(storageKey, "storageKey is required");
        this.id = Objects.requireNonNull(id, "id is required");
        this.name = Objects.requireNonNull(name2, "name is required");
        this.isDefault = Objects.requireNonNull(isDefault, "isDefault is required");
        this.expiration = Objects.requireNonNull(expiration, "expiration is required");
        this.quota = Objects.requireNonNull(quota, "quota is required");
        this.persistent = Objects.requireNonNull(persistent, "persistent is required");
        this.durability = Objects.requireNonNull(durability, "durability is required");
    }

    public SerializedStorageKey getStorageKey() {
        return this.storageKey;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public TimeSinceEpoch getExpiration() {
        return this.expiration;
    }

    public Number getQuota() {
        return this.quota;
    }

    public Boolean getPersistent() {
        return this.persistent;
    }

    public StorageBucketsDurability getDurability() {
        return this.durability;
    }

    private static StorageBucketInfo fromJson(JsonInput input) {
        SerializedStorageKey storageKey = null;
        String id = null;
        String name2 = null;
        Boolean isDefault = false;
        TimeSinceEpoch expiration = null;
        Number quota = 0;
        Boolean persistent = false;
        StorageBucketsDurability durability = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "storageKey": {
                    storageKey = (SerializedStorageKey)input.read((Type)((Object)SerializedStorageKey.class));
                    continue block20;
                }
                case "id": {
                    id = input.nextString();
                    continue block20;
                }
                case "name": {
                    name2 = input.nextString();
                    continue block20;
                }
                case "isDefault": {
                    isDefault = input.nextBoolean();
                    continue block20;
                }
                case "expiration": {
                    expiration = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block20;
                }
                case "quota": {
                    quota = input.nextNumber();
                    continue block20;
                }
                case "persistent": {
                    persistent = input.nextBoolean();
                    continue block20;
                }
                case "durability": {
                    durability = (StorageBucketsDurability)((Object)input.read((Type)((Object)StorageBucketsDurability.class)));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StorageBucketInfo(storageKey, id, name2, isDefault, expiration, quota, persistent, durability);
    }
}

