/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.input;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v85.input.model.GestureSourceType;
import org.openqa.selenium.devtools.v85.input.model.MouseButton;
import org.openqa.selenium.devtools.v85.input.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v85.input.model.TouchPoint;
import org.openqa.selenium.json.JsonInput;

public class Input {
    public static Command<Void> dispatchKeyEvent(DispatchKeyEventType type, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp, Optional<String> text, Optional<String> unmodifiedText, Optional<String> keyIdentifier, Optional<String> code, Optional<String> key, Optional<Integer> windowsVirtualKeyCode, Optional<Integer> nativeVirtualKeyCode, Optional<Boolean> autoRepeat, Optional<Boolean> isKeypad, Optional<Boolean> isSystemKey, Optional<Integer> location, Optional<List<String>> commands) {
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder<String, DispatchKeyEventType> params = ImmutableMap.builder();
        params.put("type", type);
        modifiers.ifPresent(p -> params.put("modifiers", (DispatchKeyEventType)((Object)p)));
        timestamp.ifPresent(p -> params.put("timestamp", (DispatchKeyEventType)((Object)p)));
        text.ifPresent(p -> params.put("text", (DispatchKeyEventType)((Object)p)));
        unmodifiedText.ifPresent(p -> params.put("unmodifiedText", (DispatchKeyEventType)((Object)p)));
        keyIdentifier.ifPresent(p -> params.put("keyIdentifier", (DispatchKeyEventType)((Object)p)));
        code.ifPresent(p -> params.put("code", (DispatchKeyEventType)((Object)p)));
        key.ifPresent(p -> params.put("key", (DispatchKeyEventType)((Object)p)));
        windowsVirtualKeyCode.ifPresent(p -> params.put("windowsVirtualKeyCode", (DispatchKeyEventType)((Object)p)));
        nativeVirtualKeyCode.ifPresent(p -> params.put("nativeVirtualKeyCode", (DispatchKeyEventType)((Object)p)));
        autoRepeat.ifPresent(p -> params.put("autoRepeat", (DispatchKeyEventType)((Object)p)));
        isKeypad.ifPresent(p -> params.put("isKeypad", (DispatchKeyEventType)((Object)p)));
        isSystemKey.ifPresent(p -> params.put("isSystemKey", (DispatchKeyEventType)((Object)p)));
        location.ifPresent(p -> params.put("location", (DispatchKeyEventType)((Object)p)));
        commands.ifPresent(p -> params.put("commands", (DispatchKeyEventType)((Object)p)));
        return new Command<Void>("Input.dispatchKeyEvent", params.build());
    }

    @Beta
    public static Command<Void> insertText(String text) {
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("text", text);
        return new Command<Void>("Input.insertText", params.build());
    }

    public static Command<Void> dispatchMouseEvent(DispatchMouseEventType type, Number x, Number y, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp, Optional<MouseButton> button, Optional<Integer> buttons, Optional<Integer> clickCount, Optional<Number> deltaX, Optional<Number> deltaY, Optional<DispatchMouseEventPointerType> pointerType) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("type", (Object)type);
        params.put("x", x);
        params.put("y", y);
        modifiers.ifPresent(p -> params.put("modifiers", p));
        timestamp.ifPresent(p -> params.put("timestamp", p));
        button.ifPresent(p -> params.put("button", p));
        buttons.ifPresent(p -> params.put("buttons", p));
        clickCount.ifPresent(p -> params.put("clickCount", p));
        deltaX.ifPresent(p -> params.put("deltaX", p));
        deltaY.ifPresent(p -> params.put("deltaY", p));
        pointerType.ifPresent(p -> params.put("pointerType", p));
        return new Command<Void>("Input.dispatchMouseEvent", params.build());
    }

    public static Command<Void> dispatchTouchEvent(DispatchTouchEventType type, List<TouchPoint> touchPoints, Optional<Integer> modifiers, Optional<TimeSinceEpoch> timestamp) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(touchPoints, "touchPoints is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("type", (Object)type);
        params.put("touchPoints", touchPoints);
        modifiers.ifPresent(p -> params.put("modifiers", p));
        timestamp.ifPresent(p -> params.put("timestamp", p));
        return new Command<Void>("Input.dispatchTouchEvent", params.build());
    }

    @Beta
    public static Command<Void> emulateTouchFromMouseEvent(EmulateTouchFromMouseEventType type, Integer x, Integer y, MouseButton button, Optional<TimeSinceEpoch> timestamp, Optional<Number> deltaX, Optional<Number> deltaY, Optional<Integer> modifiers, Optional<Integer> clickCount) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(button, "button is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("type", (Object)type);
        params.put("x", x);
        params.put("y", y);
        params.put("button", (Object)button);
        timestamp.ifPresent(p -> params.put("timestamp", p));
        deltaX.ifPresent(p -> params.put("deltaX", p));
        deltaY.ifPresent(p -> params.put("deltaY", p));
        modifiers.ifPresent(p -> params.put("modifiers", p));
        clickCount.ifPresent(p -> params.put("clickCount", p));
        return new Command<Void>("Input.emulateTouchFromMouseEvent", params.build());
    }

    public static Command<Void> setIgnoreInputEvents(Boolean ignore) {
        Objects.requireNonNull(ignore, "ignore is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("ignore", ignore);
        return new Command<Void>("Input.setIgnoreInputEvents", params.build());
    }

    @Beta
    public static Command<Void> synthesizePinchGesture(Number x, Number y, Number scaleFactor, Optional<Integer> relativeSpeed, Optional<GestureSourceType> gestureSourceType) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(scaleFactor, "scaleFactor is required");
        ImmutableMap.Builder<String, Number> params = ImmutableMap.builder();
        params.put("x", x);
        params.put("y", y);
        params.put("scaleFactor", scaleFactor);
        relativeSpeed.ifPresent(p -> params.put("relativeSpeed", (Number)p));
        gestureSourceType.ifPresent(p -> params.put("gestureSourceType", (Number)p));
        return new Command<Void>("Input.synthesizePinchGesture", params.build());
    }

    @Beta
    public static Command<Void> synthesizeScrollGesture(Number x, Number y, Optional<Number> xDistance, Optional<Number> yDistance, Optional<Number> xOverscroll, Optional<Number> yOverscroll, Optional<Boolean> preventFling, Optional<Integer> speed, Optional<GestureSourceType> gestureSourceType, Optional<Integer> repeatCount, Optional<Integer> repeatDelayMs, Optional<String> interactionMarkerName) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder<String, Number> params = ImmutableMap.builder();
        params.put("x", x);
        params.put("y", y);
        xDistance.ifPresent(p -> params.put("xDistance", (Number)p));
        yDistance.ifPresent(p -> params.put("yDistance", (Number)p));
        xOverscroll.ifPresent(p -> params.put("xOverscroll", (Number)p));
        yOverscroll.ifPresent(p -> params.put("yOverscroll", (Number)p));
        preventFling.ifPresent(p -> params.put("preventFling", (Number)p));
        speed.ifPresent(p -> params.put("speed", (Number)p));
        gestureSourceType.ifPresent(p -> params.put("gestureSourceType", (Number)p));
        repeatCount.ifPresent(p -> params.put("repeatCount", (Number)p));
        repeatDelayMs.ifPresent(p -> params.put("repeatDelayMs", (Number)p));
        interactionMarkerName.ifPresent(p -> params.put("interactionMarkerName", (Number)p));
        return new Command<Void>("Input.synthesizeScrollGesture", params.build());
    }

    @Beta
    public static Command<Void> synthesizeTapGesture(Number x, Number y, Optional<Integer> duration, Optional<Integer> tapCount, Optional<GestureSourceType> gestureSourceType) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder<String, Number> params = ImmutableMap.builder();
        params.put("x", x);
        params.put("y", y);
        duration.ifPresent(p -> params.put("duration", (Number)p));
        tapCount.ifPresent(p -> params.put("tapCount", (Number)p));
        gestureSourceType.ifPresent(p -> params.put("gestureSourceType", (Number)p));
        return new Command<Void>("Input.synthesizeTapGesture", params.build());
    }

    public static enum EmulateTouchFromMouseEventType {
        MOUSEPRESSED("mousePressed"),
        MOUSERELEASED("mouseReleased"),
        MOUSEMOVED("mouseMoved"),
        MOUSEWHEEL("mouseWheel");

        private String value;

        private EmulateTouchFromMouseEventType(String value) {
            this.value = value;
        }

        public static EmulateTouchFromMouseEventType fromString(String s) {
            return Arrays.stream(EmulateTouchFromMouseEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within EmulateTouchFromMouseEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static EmulateTouchFromMouseEventType fromJson(JsonInput input) {
            return EmulateTouchFromMouseEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchTouchEventType {
        TOUCHSTART("touchStart"),
        TOUCHEND("touchEnd"),
        TOUCHMOVE("touchMove"),
        TOUCHCANCEL("touchCancel");

        private String value;

        private DispatchTouchEventType(String value) {
            this.value = value;
        }

        public static DispatchTouchEventType fromString(String s) {
            return Arrays.stream(DispatchTouchEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchTouchEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchTouchEventType fromJson(JsonInput input) {
            return DispatchTouchEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchMouseEventPointerType {
        MOUSE("mouse"),
        PEN("pen");

        private String value;

        private DispatchMouseEventPointerType(String value) {
            this.value = value;
        }

        public static DispatchMouseEventPointerType fromString(String s) {
            return Arrays.stream(DispatchMouseEventPointerType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchMouseEventPointerType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchMouseEventPointerType fromJson(JsonInput input) {
            return DispatchMouseEventPointerType.fromString(input.nextString());
        }
    }

    public static enum DispatchMouseEventType {
        MOUSEPRESSED("mousePressed"),
        MOUSERELEASED("mouseReleased"),
        MOUSEMOVED("mouseMoved"),
        MOUSEWHEEL("mouseWheel");

        private String value;

        private DispatchMouseEventType(String value) {
            this.value = value;
        }

        public static DispatchMouseEventType fromString(String s) {
            return Arrays.stream(DispatchMouseEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchMouseEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchMouseEventType fromJson(JsonInput input) {
            return DispatchMouseEventType.fromString(input.nextString());
        }
    }

    public static enum DispatchKeyEventType {
        KEYDOWN("keyDown"),
        KEYUP("keyUp"),
        RAWKEYDOWN("rawKeyDown"),
        CHAR("char");

        private String value;

        private DispatchKeyEventType(String value) {
            this.value = value;
        }

        public static DispatchKeyEventType fromString(String s) {
            return Arrays.stream(DispatchKeyEventType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DispatchKeyEventType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static DispatchKeyEventType fromJson(JsonInput input) {
            return DispatchKeyEventType.fromString(input.nextString());
        }
    }
}

