/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.tracing;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.tracing.model.BufferUsage;
import org.openqa.selenium.devtools.v85.tracing.model.StreamCompression;
import org.openqa.selenium.devtools.v85.tracing.model.StreamFormat;
import org.openqa.selenium.devtools.v85.tracing.model.TraceConfig;
import org.openqa.selenium.devtools.v85.tracing.model.TracingComplete;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Tracing {
    public static Command<Void> end() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Tracing.end", params.build());
    }

    public static Command<List<String>> getCategories() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<String>>("Tracing.getCategories", params.build(), ConverterFunctions.map("categories", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<Void> recordClockSyncMarker(String syncId) {
        Objects.requireNonNull(syncId, "syncId is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("syncId", syncId);
        return new Command<Void>("Tracing.recordClockSyncMarker", params.build());
    }

    public static Command<RequestMemoryDumpResponse> requestMemoryDump(Optional<Boolean> deterministic) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        deterministic.ifPresent(p -> params.put("deterministic", p));
        return new Command<RequestMemoryDumpResponse>("Tracing.requestMemoryDump", params.build(), input -> (RequestMemoryDumpResponse)input.read((Type)((Object)RequestMemoryDumpResponse.class)));
    }

    public static Command<Void> start(Optional<String> categories2, Optional<String> options, Optional<Number> bufferUsageReportingInterval, Optional<StartTransferMode> transferMode, Optional<StreamFormat> streamFormat, Optional<StreamCompression> streamCompression, Optional<TraceConfig> traceConfig) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        categories2.ifPresent(p -> params.put("categories", p));
        options.ifPresent(p -> params.put("options", p));
        bufferUsageReportingInterval.ifPresent(p -> params.put("bufferUsageReportingInterval", p));
        transferMode.ifPresent(p -> params.put("transferMode", p));
        streamFormat.ifPresent(p -> params.put("streamFormat", p));
        streamCompression.ifPresent(p -> params.put("streamCompression", p));
        traceConfig.ifPresent(p -> params.put("traceConfig", p));
        return new Command<Void>("Tracing.start", params.build());
    }

    public static Event<BufferUsage> bufferUsage() {
        return new Event<BufferUsage>("Tracing.bufferUsage", input -> (BufferUsage)input.read((Type)((Object)BufferUsage.class)));
    }

    public static Event<List<Map<String, Object>>> dataCollected() {
        return new Event<List<Map<String, Object>>>("Tracing.dataCollected", ConverterFunctions.map("value", new TypeToken<List<Map<String, Object>>>(){}.getType()));
    }

    public static Event<TracingComplete> tracingComplete() {
        return new Event<TracingComplete>("Tracing.tracingComplete", input -> (TracingComplete)input.read((Type)((Object)TracingComplete.class)));
    }

    public static enum StartTransferMode {
        REPORTEVENTS("ReportEvents"),
        RETURNASSTREAM("ReturnAsStream");

        private String value;

        private StartTransferMode(String value) {
            this.value = value;
        }

        public static StartTransferMode fromString(String s) {
            return Arrays.stream(StartTransferMode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within StartTransferMode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static StartTransferMode fromJson(JsonInput input) {
            return StartTransferMode.fromString(input.nextString());
        }
    }

    public static class RequestMemoryDumpResponse {
        private final String dumpGuid;
        private final Boolean success;

        public RequestMemoryDumpResponse(String dumpGuid, Boolean success) {
            this.dumpGuid = Objects.requireNonNull(dumpGuid, "dumpGuid is required");
            this.success = Objects.requireNonNull(success, "success is required");
        }

        public String getDumpGuid() {
            return this.dumpGuid;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        private static RequestMemoryDumpResponse fromJson(JsonInput input) {
            String dumpGuid = null;
            Boolean success = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "dumpGuid": {
                        dumpGuid = input.nextString();
                        continue block8;
                    }
                    case "success": {
                        success = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RequestMemoryDumpResponse(dumpGuid, success);
        }
    }
}

