/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends FirefoxDriverService {
    public static final String GECKO_DRIVER_NAME = "geckodriver";
    public static final String GECKO_DRIVER_EXE_PROPERTY = "webdriver.gecko.driver";
    public static final String GECKO_DRIVER_LOG_PROPERTY = "webdriver.firefox.logfile";
    public static final String GECKO_DRIVER_LOG_LEVEL_PROPERTY = "webdriver.firefox.logLevel";
    public static final String GECKO_DRIVER_LOG_NO_TRUNCATE = "webdriver.firefox.logTruncate";
    public static final String GECKO_DRIVER_PROFILE_ROOT = "webdriver.firefox.profileRoot";

    @Deprecated
    public GeckoDriverService(File executable, int port, List<String> args2, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, Collections.unmodifiableList(new ArrayList<String>(args2)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public GeckoDriverService(File executable, int port, Duration timeout2, List<String> args2, Map<String, String> environment) throws IOException {
        super(executable, port, timeout2, Collections.unmodifiableList(new ArrayList<String>(args2)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    @Override
    public String getDriverName() {
        return GECKO_DRIVER_NAME;
    }

    @Override
    public String getDriverProperty() {
        return GECKO_DRIVER_EXE_PROPERTY;
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new FirefoxOptions();
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)new Builder().build();
    }

    static boolean isPresent() {
        return GeckoDriverService.findExePath(GECKO_DRIVER_NAME, GECKO_DRIVER_EXE_PROPERTY) != null;
    }

    @Deprecated
    static GeckoDriverService createDefaultService(Capabilities caps) {
        return GeckoDriverService.createDefaultService();
    }

    @Override
    protected void waitUntilAvailable() {
        PortProber.waitForPortUp(this.getUrl().getPort(), (int)this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected boolean hasShutdownEndpoint() {
        return false;
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends FirefoxDriverService.Builder<GeckoDriverService, Builder> {
        private FirefoxBinary firefoxBinary;
        private String allowHosts;
        private FirefoxDriverLogLevel logLevel;
        private Boolean logTruncate;
        private File profileRoot;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.FIREFOX.is(capabilities)) {
                ++score;
            }
            if (capabilities.getCapability("moz:firefoxOptions") != null) {
                ++score;
            }
            return score;
        }

        @Deprecated
        public Builder usingFirefoxBinary(FirefoxBinary firefoxBinary) {
            Require.nonNull("Firefox binary", firefoxBinary);
            this.firefoxBinary = firefoxBinary;
            return this;
        }

        public Builder withAllowHosts(String allowHosts) {
            this.allowHosts = allowHosts;
            return this;
        }

        public Builder withLogLevel(FirefoxDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withTruncatedLogs(Boolean truncate) {
            this.logTruncate = truncate;
            return this;
        }

        public Builder withProfileRoot(File root) {
            this.profileRoot = root;
            return this;
        }

        @Override
        protected void loadSystemProperties() {
            String profileRootFromProperty;
            String logFilePath;
            if (this.logLevel == null && (logFilePath = System.getProperty(GeckoDriverService.GECKO_DRIVER_LOG_LEVEL_PROPERTY)) != null) {
                this.logLevel = FirefoxDriverLogLevel.fromString(logFilePath);
            }
            if (this.logTruncate == null) {
                this.logTruncate = !Boolean.getBoolean(GeckoDriverService.GECKO_DRIVER_LOG_NO_TRUNCATE);
            }
            if (this.profileRoot == null && (profileRootFromProperty = System.getProperty(GeckoDriverService.GECKO_DRIVER_PROFILE_ROOT)) != null) {
                this.profileRoot = new File(profileRootFromProperty);
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList<String> args2 = new ArrayList<String>();
            args2.add(String.format("--port=%d", this.getPort()));
            int wsPort = PortProber.findFreePort();
            args2.add(String.format("--websocket-port=%d", wsPort));
            args2.add("--allow-origins");
            args2.add(String.format("http://127.0.0.1:%d", wsPort));
            args2.add(String.format("http://localhost:%d", wsPort));
            args2.add(String.format("http://[::1]:%d", wsPort));
            if (this.logLevel != null) {
                args2.add("--log");
                args2.add(this.logLevel.toString());
            }
            if (this.logTruncate != null && this.logTruncate.equals(Boolean.FALSE)) {
                args2.add("--log-no-truncate");
            }
            if (this.profileRoot != null) {
                args2.add("--profile-root");
                args2.add(this.profileRoot.getAbsolutePath());
            }
            if (this.firefoxBinary != null) {
                args2.add("--binary");
                args2.add(this.firefoxBinary.getPath());
            }
            if (this.allowHosts != null) {
                args2.add("--allow-hosts");
                args2.addAll(Arrays.asList(this.allowHosts.split(" ")));
            }
            return Collections.unmodifiableList(args2);
        }

        @Override
        protected GeckoDriverService createDriverService(File exe, int port, Duration timeout2, List<String> args2, Map<String, String> environment) {
            try {
                GeckoDriverService service = new GeckoDriverService(exe, port, timeout2, args2, environment);
                service.sendOutputTo(this.getLogOutput(GeckoDriverService.GECKO_DRIVER_LOG_PROPERTY));
                return service;
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

