/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntConsumer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.KeyInput;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.interactions.WheelInput;
import org.openqa.selenium.internal.Require;

public class Actions {
    private final WebDriver driver;
    private final Map<InputSource, Sequence> sequences = new HashMap<InputSource, Sequence>();
    private PointerInput activePointer;
    private KeyInput activeKeyboard;
    private WheelInput activeWheel;

    public Actions(WebDriver driver) {
        this.driver = Require.nonNull("Driver", driver);
    }

    public Actions keyDown(CharSequence key) {
        return this.addKeyAction(key, codePoint -> this.tick(this.getActiveKeyboard().createKeyDown(codePoint)));
    }

    public Actions keyDown(WebElement target, CharSequence key) {
        return this.focusInTicks(target).addKeyAction(key, codepoint -> this.tick(this.getActiveKeyboard().createKeyDown(codepoint)));
    }

    public Actions keyUp(CharSequence key) {
        return this.addKeyAction(key, codePoint -> this.tick(this.getActiveKeyboard().createKeyUp(codePoint)));
    }

    public Actions keyUp(WebElement target, CharSequence key) {
        return this.focusInTicks(target).addKeyAction(key, codePoint -> this.tick(this.getActiveKeyboard().createKeyUp(codePoint)));
    }

    public Actions sendKeys(CharSequence ... keys2) {
        return this.sendKeysInTicks(keys2);
    }

    public Actions sendKeys(WebElement target, CharSequence ... keys2) {
        return this.focusInTicks(target).sendKeysInTicks(keys2);
    }

    private Actions sendKeysInTicks(CharSequence ... keys2) {
        if (keys2 == null) {
            throw new IllegalArgumentException("Keys should be a not null CharSequence");
        }
        for (CharSequence key : keys2) {
            key.codePoints().forEach(codePoint -> {
                this.tick(this.getActiveKeyboard().createKeyDown(codePoint));
                this.tick(this.getActiveKeyboard().createKeyUp(codePoint));
            });
        }
        return this;
    }

    private Actions addKeyAction(CharSequence key, IntConsumer consumer) {
        if (key.codePoints().count() != 1L) {
            throw new IllegalStateException(String.format("Only one code point is allowed at a time: %s", key));
        }
        key.codePoints().forEach(consumer);
        return this;
    }

    public Actions clickAndHold(WebElement target) {
        return this.moveInTicks(target, 0, 0).tick(this.getActivePointer().createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions clickAndHold() {
        return this.tick(this.getActivePointer().createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions release(WebElement target) {
        return this.moveInTicks(target, 0, 0).tick(this.getActivePointer().createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions scrollToElement(WebElement element) {
        WheelInput.ScrollOrigin scrollOrigin = WheelInput.ScrollOrigin.fromElement(element);
        return this.tick(this.getActiveWheel().createScroll(0, 0, 0, 0, Duration.ofMillis(250L), scrollOrigin));
    }

    public Actions scrollByAmount(int deltaX, int deltaY) {
        WheelInput.ScrollOrigin scrollOrigin = WheelInput.ScrollOrigin.fromViewport();
        return this.tick(this.getActiveWheel().createScroll(0, 0, deltaX, deltaY, Duration.ofMillis(250L), scrollOrigin));
    }

    public Actions scrollFromOrigin(WheelInput.ScrollOrigin scrollOrigin, int deltaX, int deltaY) {
        int x = scrollOrigin.getxOffset();
        int y = scrollOrigin.getyOffset();
        return this.tick(this.getActiveWheel().createScroll(x, y, deltaX, deltaY, Duration.ofMillis(250L), scrollOrigin));
    }

    public Actions release() {
        return this.tick(this.getActivePointer().createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions click(WebElement target) {
        return this.moveInTicks(target, 0, 0).clickInTicks(PointerInput.MouseButton.LEFT);
    }

    public Actions click() {
        return this.clickInTicks(PointerInput.MouseButton.LEFT);
    }

    private Actions clickInTicks(PointerInput.MouseButton button) {
        this.tick(this.getActivePointer().createPointerDown(button.asArg()));
        this.tick(this.getActivePointer().createPointerUp(button.asArg()));
        return this;
    }

    private Actions focusInTicks(WebElement target) {
        return this.moveInTicks(target, 0, 0).clickInTicks(PointerInput.MouseButton.LEFT);
    }

    public Actions doubleClick(WebElement target) {
        return this.moveInTicks(target, 0, 0).clickInTicks(PointerInput.MouseButton.LEFT).clickInTicks(PointerInput.MouseButton.LEFT);
    }

    public Actions doubleClick() {
        return this.clickInTicks(PointerInput.MouseButton.LEFT).clickInTicks(PointerInput.MouseButton.LEFT);
    }

    public Actions moveToElement(WebElement target) {
        return this.moveInTicks(target, 0, 0);
    }

    public Actions moveToElement(WebElement target, int xOffset, int yOffset) {
        return this.moveInTicks(target, xOffset, yOffset);
    }

    private Actions moveInTicks(WebElement target, int xOffset, int yOffset) {
        return this.tick(this.getActivePointer().createPointerMove(Duration.ofMillis(100L), PointerInput.Origin.fromElement(target), xOffset, yOffset));
    }

    public Actions moveByOffset(int xOffset, int yOffset) {
        return this.tick(this.getActivePointer().createPointerMove(Duration.ofMillis(200L), PointerInput.Origin.pointer(), xOffset, yOffset));
    }

    public Actions contextClick(WebElement target) {
        return this.moveInTicks(target, 0, 0).clickInTicks(PointerInput.MouseButton.RIGHT);
    }

    public Actions contextClick() {
        return this.clickInTicks(PointerInput.MouseButton.RIGHT);
    }

    public Actions dragAndDrop(WebElement source, WebElement target) {
        return this.moveInTicks(source, 0, 0).tick(this.getActivePointer().createPointerDown(PointerInput.MouseButton.LEFT.asArg())).moveInTicks(target, 0, 0).tick(this.getActivePointer().createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions dragAndDropBy(WebElement source, int xOffset, int yOffset) {
        return this.moveInTicks(source, 0, 0).tick(this.getActivePointer().createPointerDown(PointerInput.MouseButton.LEFT.asArg())).tick(this.getActivePointer().createPointerMove(Duration.ofMillis(250L), PointerInput.Origin.pointer(), xOffset, yOffset)).tick(this.getActivePointer().createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
    }

    public Actions pause(long pause) {
        return this.tick(new Pause(this.getActivePointer(), Duration.ofMillis(pause)));
    }

    public Actions pause(Duration duration) {
        Require.nonNegative("Duration of pause", duration);
        return this.tick(new Pause(this.getActivePointer(), duration));
    }

    public Actions tick(Interaction ... actions) {
        HashSet<InputSource> seenSources = new HashSet<InputSource>();
        for (Interaction action : actions) {
            boolean freshlyAdded = seenSources.add(action.getSource());
            if (freshlyAdded) continue;
            throw new IllegalStateException(String.format("You may only add one action per input source per tick: %s", Arrays.asList(actions)));
        }
        for (Interaction action : actions) {
            Sequence sequence = this.getSequence(action.getSource());
            sequence.addAction(action);
        }
        HashSet<InputSource> unseen = new HashSet<InputSource>(this.sequences.keySet());
        unseen.removeAll(seenSources);
        for (InputSource source : unseen) {
            this.getSequence(source).addAction(new Pause(source, Duration.ZERO));
        }
        return this;
    }

    public Actions setActiveKeyboard(String name2) {
        InputSource inputSource = this.sequences.keySet().stream().filter(input -> Objects.equals(input.getName(), name2)).findFirst().orElse(null);
        this.activeKeyboard = inputSource == null ? new KeyInput(name2) : (KeyInput)inputSource;
        return this;
    }

    public Actions setActivePointer(PointerInput.Kind kind, String name2) {
        InputSource inputSource = this.sequences.keySet().stream().filter(input -> Objects.equals(input.getName(), name2)).findFirst().orElse(null);
        this.activePointer = inputSource == null ? new PointerInput(kind, name2) : (PointerInput)inputSource;
        return this;
    }

    public Actions setActiveWheel(String name2) {
        InputSource inputSource = this.sequences.keySet().stream().filter(input -> Objects.equals(input.getName(), name2)).findFirst().orElse(null);
        this.activeWheel = inputSource == null ? new WheelInput(name2) : (WheelInput)inputSource;
        return this;
    }

    public KeyInput getActiveKeyboard() {
        if (this.activeKeyboard == null) {
            this.setActiveKeyboard("default keyboard");
        }
        return this.activeKeyboard;
    }

    public PointerInput getActivePointer() {
        if (this.activePointer == null) {
            this.setActivePointer(PointerInput.Kind.MOUSE, "default mouse");
        }
        return this.activePointer;
    }

    public WheelInput getActiveWheel() {
        if (this.activeWheel == null) {
            this.setActiveWheel("default wheel");
        }
        return this.activeWheel;
    }

    public Action build() {
        BuiltAction toReturn = new BuiltAction(this.driver, new LinkedHashMap<InputSource, Sequence>(this.sequences));
        this.sequences.clear();
        return toReturn;
    }

    public void perform() {
        this.build().perform();
    }

    private Sequence getSequence(InputSource source) {
        Sequence sequence = this.sequences.get(source);
        if (sequence != null) {
            return sequence;
        }
        int longest = 0;
        for (Sequence examining : this.sequences.values()) {
            longest = Math.max(longest, examining.size());
        }
        sequence = new Sequence(source, longest);
        this.sequences.put(source, sequence);
        return sequence;
    }

    private static class BuiltAction
    implements Action {
        private final WebDriver driver;
        private final Map<InputSource, Sequence> sequences;

        private BuiltAction(WebDriver driver, Map<InputSource, Sequence> sequences) {
            this.driver = driver;
            this.sequences = sequences;
        }

        @Override
        public void perform() {
            ((Interactive)((Object)this.driver)).perform(this.sequences.values());
        }
    }
}

