/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class RemoteWebElement
implements WebElement,
Locatable,
TakesScreenshot,
WrapsDriver {
    private String foundBy;
    protected String id;
    protected RemoteWebDriver parent;
    protected FileDetector fileDetector;

    protected void setFoundBy(SearchContext foundFrom, String locator, String term) {
        this.foundBy = String.format("[%s] -> %s: %s", foundFrom, locator, term);
    }

    public void setParent(RemoteWebDriver parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFileDetector(FileDetector detector) {
        this.fileDetector = detector;
    }

    @Override
    public void click() {
        this.execute(DriverCommand.CLICK_ELEMENT(this.id));
    }

    @Override
    public void submit() {
        try {
            this.execute(DriverCommand.SUBMIT_ELEMENT(this.id));
        }
        catch (JavascriptException ex) {
            String message = "To submit an element, it must be nested inside a form element";
            throw new UnsupportedOperationException(message);
        }
    }

    @Override
    public void sendKeys(CharSequence ... keysToSend) {
        if (keysToSend == null || keysToSend.length == 0) {
            throw new IllegalArgumentException("Keys to send should be a not null CharSequence");
        }
        for (CharSequence cs : keysToSend) {
            if (cs != null) continue;
            throw new IllegalArgumentException("Keys to send should be a not null CharSequence");
        }
        String allKeysToSend = String.join((CharSequence)"", keysToSend);
        List files = Arrays.stream(allKeysToSend.split("\n")).map(xva$0 -> this.fileDetector.getLocalFile((CharSequence)xva$0)).collect(Collectors.toList());
        if (!files.isEmpty() && !files.contains(null)) {
            allKeysToSend = files.stream().map(this::upload).collect(Collectors.joining("\n"));
        }
        this.execute(DriverCommand.SEND_KEYS_TO_ELEMENT(this.id, new CharSequence[]{allKeysToSend}));
    }

    private String upload(File localFile) {
        if (!localFile.isFile()) {
            throw new WebDriverException("You may only upload files: " + localFile);
        }
        try {
            String zip2 = Zip.zip(localFile);
            Response response = this.execute(DriverCommand.UPLOAD_FILE(zip2));
            return (String)response.getValue();
        }
        catch (IOException e) {
            throw new WebDriverException("Cannot upload " + localFile, e);
        }
    }

    @Override
    public void clear() {
        this.execute(DriverCommand.CLEAR_ELEMENT(this.id));
    }

    @Override
    public String getTagName() {
        return (String)this.execute(DriverCommand.GET_ELEMENT_TAG_NAME(this.id)).getValue();
    }

    @Override
    public String getDomProperty(String name2) {
        return RemoteWebElement.stringValueOf(this.execute(DriverCommand.GET_ELEMENT_DOM_PROPERTY(this.id, name2)).getValue());
    }

    @Override
    public String getDomAttribute(String name2) {
        return RemoteWebElement.stringValueOf(this.execute(DriverCommand.GET_ELEMENT_DOM_ATTRIBUTE(this.id, name2)).getValue());
    }

    @Override
    public String getAttribute(String name2) {
        return RemoteWebElement.stringValueOf(this.execute(DriverCommand.GET_ELEMENT_ATTRIBUTE(this.id, name2)).getValue());
    }

    @Override
    public String getAriaRole() {
        return RemoteWebElement.stringValueOf(this.execute(DriverCommand.GET_ELEMENT_ARIA_ROLE(this.id)).getValue());
    }

    @Override
    public String getAccessibleName() {
        return RemoteWebElement.stringValueOf(this.execute(DriverCommand.GET_ELEMENT_ACCESSIBLE_NAME(this.id)).getValue());
    }

    private static String stringValueOf(Object o) {
        if (o == null) {
            return null;
        }
        return String.valueOf(o);
    }

    @Override
    public boolean isSelected() {
        Object value = this.execute(DriverCommand.IS_ELEMENT_SELECTED(this.id)).getValue();
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public boolean isEnabled() {
        Object value = this.execute(DriverCommand.IS_ELEMENT_ENABLED(this.id)).getValue();
        try {
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public String getText() {
        Response response = this.execute(DriverCommand.GET_ELEMENT_TEXT(this.id));
        return (String)response.getValue();
    }

    @Override
    public String getCssValue(String propertyName) {
        Response response = this.execute(DriverCommand.GET_ELEMENT_VALUE_OF_CSS_PROPERTY(this.id, propertyName));
        return (String)response.getValue();
    }

    @Override
    public List<WebElement> findElements(By locator) {
        return this.parent.findElements(this, (using, value) -> DriverCommand.FIND_CHILD_ELEMENTS(this.getId(), using, String.valueOf(value)), locator);
    }

    @Override
    public WebElement findElement(By locator) {
        return this.parent.findElement(this, (using, value) -> DriverCommand.FIND_CHILD_ELEMENT(this.getId(), using, String.valueOf(value)), locator);
    }

    @Deprecated
    protected WebElement findElement(String using, String value) {
        throw new UnsupportedOperationException("`findElement` has been replaced by usages of " + By.Remotable.class);
    }

    @Deprecated
    protected List<WebElement> findElements(String using, String value) {
        throw new UnsupportedOperationException("`findElement` has been replaced by usages of " + By.Remotable.class);
    }

    @Override
    public SearchContext getShadowRoot() {
        Response response = this.execute(DriverCommand.GET_ELEMENT_SHADOW_ROOT(this.getId()));
        return (SearchContext)response.getValue();
    }

    protected Response execute(CommandPayload payload) {
        try {
            return this.parent.execute(payload);
        }
        catch (WebDriverException ex) {
            ex.addInfo("Element", this.toString());
            throw ex;
        }
    }

    protected Response execute(String command, Map<String, ?> parameters) {
        try {
            return this.parent.execute(command, parameters);
        }
        catch (WebDriverException ex) {
            ex.addInfo("Element", this.toString());
            throw ex;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        while (other instanceof WrapsElement) {
            other = ((WrapsElement)((Object)other)).getWrappedElement();
        }
        if (!(other instanceof RemoteWebElement)) {
            return false;
        }
        RemoteWebElement otherRemoteWebElement = (RemoteWebElement)other;
        return this.id.equals(otherRemoteWebElement.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    @Override
    public boolean isDisplayed() {
        Object value = this.execute(DriverCommand.IS_ELEMENT_DISPLAYED(this.id)).getValue();
        try {
            if (value == null) {
                return false;
            }
            return (Boolean)value;
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to Boolean: " + value, ex);
        }
    }

    @Override
    public Point getLocation() {
        Response response = this.execute(DriverCommand.GET_ELEMENT_RECT(this.id));
        Map rawPoint = (Map)response.getValue();
        int x = ((Number)rawPoint.get("x")).intValue();
        int y = ((Number)rawPoint.get("y")).intValue();
        return new Point(x, y);
    }

    @Override
    public Dimension getSize() {
        Response response = this.execute(DriverCommand.GET_ELEMENT_RECT(this.id));
        Map rawSize = (Map)response.getValue();
        int width = ((Number)rawSize.get("width")).intValue();
        int height = ((Number)rawSize.get("height")).intValue();
        return new Dimension(width, height);
    }

    @Override
    public Rectangle getRect() {
        Response response = this.execute(DriverCommand.GET_ELEMENT_RECT(this.id));
        Map rawRect = (Map)response.getValue();
        int x = ((Number)rawRect.get("x")).intValue();
        int y = ((Number)rawRect.get("y")).intValue();
        int width = ((Number)rawRect.get("width")).intValue();
        int height = ((Number)rawRect.get("height")).intValue();
        return new Rectangle(x, y, height, width);
    }

    @Override
    public Coordinates getCoordinates() {
        return new Coordinates(){

            @Override
            public Point onScreen() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Point inViewPort() {
                Response response = RemoteWebElement.this.execute(DriverCommand.GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW(RemoteWebElement.this.getId()));
                Map mapped = (Map)response.getValue();
                return new Point(((Number)mapped.get("x")).intValue(), ((Number)mapped.get("y")).intValue());
            }

            @Override
            public Point onPage() {
                return RemoteWebElement.this.getLocation();
            }

            @Override
            public Object getAuxiliary() {
                return RemoteWebElement.this.getId();
            }
        };
    }

    @Override
    @Beta
    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Response response = this.execute(DriverCommand.ELEMENT_SCREENSHOT(this.id));
        Object result = response.getValue();
        if (result instanceof String) {
            String base64EncodedPng = (String)result;
            return outputType.convertFromBase64Png(base64EncodedPng);
        }
        if (result instanceof byte[]) {
            return outputType.convertFromPngBytes((byte[])result);
        }
        throw new RuntimeException(String.format("Unexpected result for %s command: %s", "elementScreenshot", result == null ? "null" : result.getClass().getName() + " instance"));
    }

    public String toString() {
        if (this.foundBy == null) {
            return String.format("[%s -> unknown locator]", super.toString());
        }
        return String.format("[%s]", this.foundBy);
    }

    public Map<String, Object> toJson() {
        return ImmutableMap.of(Dialect.W3C.getEncodedElementKey(), this.getId());
    }
}

