/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;

public class HttpRequest
extends HttpMessage<HttpRequest> {
    private final HttpMethod method;
    private final String uri;
    private final Multimap<String, String> queryParameters = ArrayListMultimap.create();

    public HttpRequest(HttpMethod method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getQueryParameter(String name2) {
        Iterable<String> allParams = this.getQueryParameters(name2);
        if (allParams == null) {
            return null;
        }
        Iterator<String> iterator2 = allParams.iterator();
        return iterator2.hasNext() ? iterator2.next() : null;
    }

    public HttpRequest addQueryParameter(String name2, String value) {
        this.queryParameters.put(Require.nonNull("Name", name2), Require.nonNull("Value", value));
        return this;
    }

    public Iterable<String> getQueryParameterNames() {
        return this.queryParameters.keySet();
    }

    public Iterable<String> getQueryParameters(String name2) {
        return this.queryParameters.get(name2);
    }

    public String toString() {
        return "(" + (Object)((Object)this.getMethod()) + ") " + this.getUri();
    }
}

