/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlTemplate {
    private static final Pattern GROUP_NAME = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
    private final List<Matches> template;

    public UrlTemplate(String template) {
        if (template == null || template.isEmpty()) {
            throw new IllegalArgumentException("Template must not be 0 length");
        }
        ImmutableList.Builder fragments = ImmutableList.builder();
        for (String fragment : template.split("/")) {
            Matcher matcher = Pattern.compile("\\{(\\p{Alnum}+?)\\}").matcher(fragment);
            String toCompile = matcher.replaceAll("(?<$1>[^/]+)");
            Matcher groupNameMatcher = GROUP_NAME.matcher(toCompile);
            ImmutableList.Builder names = ImmutableList.builder();
            while (groupNameMatcher.find()) {
                names.add(groupNameMatcher.group(1));
            }
            fragments.add(new Matches(Pattern.compile(Matcher.quoteReplacement(toCompile)), (List)((Object)names.build())));
        }
        this.template = fragments.build();
    }

    public Match match(String matchAgainst) {
        if (matchAgainst == null) {
            return null;
        }
        String[] fragments = matchAgainst.split("/");
        if (fragments.length != this.template.size()) {
            return null;
        }
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        for (int i = 0; i < fragments.length; ++i) {
            Matcher matcher = this.template.get(i).matcher(fragments[i]);
            if (!matcher.find()) {
                return null;
            }
            for (String name2 : this.template.get(i).groupNames) {
                params.put(name2, matcher.group(name2));
            }
        }
        return new Match(matchAgainst, params.build());
    }

    private static class Matches {
        private final Pattern pattern;
        private final List<String> groupNames;

        private Matches(Pattern pattern, List<String> groupNames) {
            this.pattern = pattern;
            this.groupNames = groupNames;
        }

        public Matcher matcher(String fragment) {
            return this.pattern.matcher(fragment);
        }
    }

    public class Match {
        private final String url;
        private final Map<String, String> parameters;

        private Match(String url, Map<String, String> parameters) {
            this.url = url;
            this.parameters = ImmutableMap.copyOf(parameters);
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

