/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.UnixChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.RemoteCall;
import org.openqa.selenium.remote.http.WebSocket;

class NettyDomainSocketClient
extends RemoteCall
implements HttpClient {
    private final EventLoopGroup eventLoopGroup;
    private final Class<? extends Channel> channelClazz;
    private final String path;

    public NettyDomainSocketClient(ClientConfig config) {
        super(config);
        URI uri = config.baseUri();
        Require.argument("URI scheme", uri.getScheme()).equalTo("unix");
        if (Epoll.isAvailable()) {
            this.eventLoopGroup = new EpollEventLoopGroup();
            this.channelClazz = EpollDomainSocketChannel.class;
        } else if (KQueue.isAvailable()) {
            this.eventLoopGroup = new KQueueEventLoopGroup();
            this.channelClazz = KQueueDomainSocketChannel.class;
        } else {
            throw new IllegalStateException("No native library for unix domain sockets is available");
        }
        this.path = uri.getPath();
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Require.nonNull("Request to send", req);
        AtomicReference<HttpResponse> outRef = new AtomicReference<HttpResponse>();
        CountDownLatch latch = new CountDownLatch(1);
        Channel channel = this.createChannel(outRef, latch);
        StringBuilder uri = new StringBuilder(req.getUri());
        ArrayList queryPairs = new ArrayList();
        req.getQueryParameterNames().forEach(name2 -> req.getQueryParameters((String)name2).forEach(value -> {
            try {
                queryPairs.add(URLEncoder.encode(name2, StandardCharsets.UTF_8.toString()) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedIOException(e);
            }
        }));
        if (!queryPairs.isEmpty()) {
            uri.append("?");
            Joiner.on('&').appendTo(uri, (Iterable<?>)queryPairs);
        }
        byte[] bytes = Contents.bytes(req.getContent());
        DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf(req.getMethod().toString()), uri.toString(), Unpooled.wrappedBuffer(bytes));
        req.getHeaderNames().forEach(name2 -> req.getHeaders((String)name2).forEach(value -> fullRequest.headers().add((String)name2, value)));
        if (req.getHeader("User-Agent") == null) {
            fullRequest.headers().set("User-Agent", (Object)AddSeleniumUserAgent.USER_AGENT);
        }
        fullRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        fullRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        ChannelFuture future = channel.writeAndFlush(fullRequest);
        try {
            future.get();
            channel.closeFuture().sync();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new IOException(e));
        }
        try {
            if (!latch.await(this.getConfig().readTimeout().toMillis(), TimeUnit.MILLISECONDS)) {
                throw new UncheckedIOException(new IOException("Timed out waiting for response"));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return outRef.get();
    }

    @Override
    public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
        throw new UnsupportedOperationException("openSocket");
    }

    private Channel createChannel(final AtomicReference<HttpResponse> outRef, final CountDownLatch latch) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(this.channelClazz)).handler(new ChannelInitializer<UnixChannel>(){

            @Override
            public void initChannel(UnixChannel ch) {
                ch.pipeline().addLast(new HttpClientCodec()).addLast(new HttpContentDecompressor()).addLast(new HttpObjectAggregator(Integer.MAX_VALUE)).addLast(new SimpleChannelInboundHandler<FullHttpResponse>(){

                    @Override
                    public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
                        HttpResponse res = new HttpResponse().setStatus(msg.status().code());
                        msg.headers().forEach(entry -> res.addHeader((String)entry.getKey(), (String)entry.getValue()));
                        try (ByteBufInputStream is = new ByteBufInputStream(msg.content());
                             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                            ByteStreams.copy(is, bos);
                            res.setContent((Supplier)Contents.bytes(bos.toByteArray()));
                            outRef.set(res);
                            latch.countDown();
                        }
                        catch (IOException e) {
                            outRef.set((HttpResponse)new HttpResponse().setStatus(500).setContent((Supplier)Contents.utf8String(Throwables.getStackTraceAsString(e))));
                            latch.countDown();
                        }
                    }

                    @Override
                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        outRef.set((HttpResponse)new HttpResponse().setStatus(500).setContent((Supplier)Contents.utf8String(Throwables.getStackTraceAsString(cause))));
                        latch.countDown();
                    }
                });
            }
        });
        try {
            return bootstrap.connect(new DomainSocketAddress(this.path)).sync().channel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

