/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.ExecutorServices;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.remote.service.DriverFinder;

public class DriverService
implements Closeable {
    public static final String LOG_NULL = "/dev/null";
    public static final String LOG_STDERR = "/dev/stderr";
    public static final String LOG_STDOUT = "/dev/stdout";
    private static final String NAME = "Driver Service Executor";
    protected static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(20L);
    private static final Logger LOG = Logger.getLogger(DriverService.class.getName());
    private final ExecutorService executorService = Executors.newFixedThreadPool(2, r -> {
        Thread thread2 = new Thread(r);
        thread2.setName(NAME);
        thread2.setDaemon(true);
        return thread2;
    });
    private final URL url;
    private String executable;
    private final ReentrantLock lock = new ReentrantLock();
    private final Duration timeout;
    private final List<String> args;
    private final Map<String, String> environment;
    protected CommandLine process = null;
    private OutputStream outputStream = System.err;

    protected DriverService(File executable, int port, Duration timeout2, List<String> args2, Map<String, String> environment) throws IOException {
        if (executable != null) {
            this.executable = executable.getCanonicalPath();
        }
        this.timeout = timeout2;
        this.args = args2;
        this.environment = environment;
        this.url = this.getUrl(port);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    protected static String findExePath(String exeName, String exeProperty) {
        String defaultPath = new ExecutableFinder().find(exeName);
        return System.getProperty(exeProperty, defaultPath);
    }

    protected List<String> getArgs() {
        return this.args;
    }

    protected Map<String, String> getEnvironment() {
        return this.environment;
    }

    protected URL getUrl(int port) throws IOException {
        return new URL(String.format("http://localhost:%d", port));
    }

    protected Capabilities getDefaultDriverOptions() {
        return new ImmutableCapabilities();
    }

    protected String getDriverName() {
        return null;
    }

    protected String getDriverProperty() {
        return null;
    }

    protected File getDriverExecutable() {
        return null;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.process != null && this.process.isRunning();
            return bl;
        }
        catch (IllegalThreadStateException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.lock.lock();
        try {
            if (this.process != null) {
                return;
            }
            if (this.executable == null) {
                if (this.getDefaultDriverOptions().getBrowserName().isEmpty()) {
                    throw new WebDriverException("Driver executable is null and browser name is not set.");
                }
                this.executable = DriverFinder.getPath(this, this.getDefaultDriverOptions());
            }
            LOG.fine(String.format("Starting driver at %s with %s", this.executable, this.args));
            this.process = new CommandLine(this.executable, this.args.toArray(new String[0]));
            this.process.setEnvironmentVariables(this.environment);
            this.process.copyOutputTo(this.getOutputStream());
            this.process.executeAsync();
            if (!this.process.waitForProcessStarted(this.timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new WebDriverException("Timed out waiting for driver process to start.");
            }
            CompletableFuture<StartOrDie> serverStarted = CompletableFuture.supplyAsync(() -> {
                this.waitUntilAvailable();
                return StartOrDie.SERVER_STARTED;
            }, this.executorService);
            CompletableFuture<StartOrDie> processFinished = CompletableFuture.supplyAsync(() -> {
                try {
                    this.process.waitFor(this.getTimeout().toMillis());
                }
                catch (TimeoutException ex) {
                    return StartOrDie.PROCESS_IS_ACTIVE;
                }
                return StartOrDie.PROCESS_DIED;
            }, this.executorService);
            try {
                StartOrDie status = (StartOrDie)((Object)CompletableFuture.anyOf(serverStarted, processFinished).get(this.getTimeout().toMillis() * 2L, TimeUnit.MILLISECONDS));
                switch (status) {
                    case SERVER_STARTED: {
                        processFinished.cancel(true);
                        break;
                    }
                    case PROCESS_DIED: {
                        this.process = null;
                        throw new WebDriverException("Driver server process died prematurely.");
                    }
                    case PROCESS_IS_ACTIVE: {
                        throw new WebDriverException("Timed out waiting for driver server to bind the port.");
                    }
                }
            }
            catch (ExecutionException | java.util.concurrent.TimeoutException e) {
                throw new WebDriverException("Timed out waiting for driver server to start.", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException("Timed out waiting for driver server to start.", e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Duration getTimeout() {
        return this.timeout;
    }

    protected void waitUntilAvailable() {
        try {
            URL status = new URL(this.url.toString() + "/status");
            new UrlChecker().waitUntilAvailable(this.getTimeout().toMillis(), TimeUnit.MILLISECONDS, status);
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Driver server status URL is malformed.", e);
        }
        catch (UrlChecker.TimeoutException e) {
            throw new WebDriverException("Timed out waiting for driver server to start.", e);
        }
    }

    public void stop() {
        this.lock.lock();
        WebDriverException toThrow = null;
        try {
            if (this.process == null) {
                return;
            }
            if (this.hasShutdownEndpoint()) {
                try {
                    URL killUrl = new URL(this.url.toString() + "/shutdown");
                    new UrlChecker().waitUntilUnavailable(3L, TimeUnit.SECONDS, killUrl);
                }
                catch (MalformedURLException e) {
                    toThrow = new WebDriverException(e);
                }
                catch (UrlChecker.TimeoutException e) {
                    toThrow = new WebDriverException("Timed out waiting for driver server to shutdown.", e);
                }
            }
            this.process.destroy();
            if (this.getOutputStream() instanceof FileOutputStream) {
                try {
                    this.getOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.process = null;
            this.lock.unlock();
            this.close();
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    protected boolean hasShutdownEndpoint() {
        return true;
    }

    public void sendOutputTo(OutputStream outputStream) {
        this.outputStream = Require.nonNull("Output stream", outputStream);
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() {
        ExecutorServices.shutdownGracefully(NAME, this.executorService);
    }

    public static abstract class Builder<DS extends DriverService, B extends Builder<?, ?>> {
        private int port = 0;
        private File exe = null;
        private Map<String, String> environment = Collections.emptyMap();
        private File logFile;
        private Duration timeout;
        private OutputStream logOutputStream;

        public abstract int score(Capabilities var1);

        public B usingDriverExecutable(File file) {
            Require.nonNull("Driver executable file", file);
            this.exe = file;
            return (B)this;
        }

        public B usingPort(int port) {
            this.port = Require.nonNegative("Port number", port);
            return (B)this;
        }

        protected int getPort() {
            return this.port;
        }

        public B usingAnyFreePort() {
            this.port = 0;
            return (B)this;
        }

        @Beta
        public B withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return (B)this;
        }

        public B withLogFile(File logFile) {
            this.logFile = logFile;
            return (B)this;
        }

        public B withLogOutput(OutputStream output) {
            this.logOutputStream = output;
            return (B)this;
        }

        protected File getLogFile() {
            return this.logFile;
        }

        public B withTimeout(Duration timeout2) {
            this.timeout = timeout2;
            return (B)this;
        }

        protected Duration getDefaultTimeout() {
            return DEFAULT_TIMEOUT;
        }

        protected OutputStream getLogOutput(String logProperty) {
            if (this.logOutputStream != null) {
                return this.logOutputStream;
            }
            try {
                File logFileLocation = this.getLogFile();
                String logLocation = logFileLocation == null ? System.getProperty(logProperty) : logFileLocation.getAbsolutePath();
                if (logLocation == null) {
                    LOG.info("Driver logs no longer sent to console by default; https://www.selenium.dev/documentation/webdriver/drivers/service/#setting-log-output");
                    return ByteStreams.nullOutputStream();
                }
                switch (logLocation) {
                    case "/dev/stdout": {
                        return System.out;
                    }
                    case "/dev/stderr": {
                        return System.err;
                    }
                    case "/dev/null": {
                        return ByteStreams.nullOutputStream();
                    }
                }
                return new FileOutputStream(logLocation);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public DS build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            if (this.timeout == null) {
                this.timeout = this.getDefaultTimeout();
            }
            this.loadSystemProperties();
            List<String> args2 = this.createArgs();
            DS service = this.createDriverService(this.exe, this.port, this.timeout, args2, this.environment);
            this.port = 0;
            return service;
        }

        protected abstract void loadSystemProperties();

        protected abstract List<String> createArgs();

        protected abstract DS createDriverService(File var1, int var2, Duration var3, List<String> var4, Map<String, String> var5);
    }

    private static enum StartOrDie {
        SERVER_STARTED,
        PROCESS_IS_ACTIVE,
        PROCESS_DIED;

    }
}

