/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.Collections;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.Browser;

public class SafariOptions
extends AbstractDriverOptions<SafariOptions> {
    public SafariOptions() {
        this.setUseTechnologyPreview(false);
        this.setCapability("browserName", Browser.SAFARI.browserName());
    }

    public SafariOptions(Capabilities source) {
        this();
        source.getCapabilityNames().forEach(name2 -> this.setCapability((String)name2, source.getCapability((String)name2)));
    }

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        if (capabilities instanceof SafariOptions) {
            return (SafariOptions)capabilities;
        }
        return new SafariOptions(capabilities);
    }

    @Override
    public SafariOptions merge(Capabilities extraCapabilities) {
        Require.nonNull("Capabilities to merge", extraCapabilities);
        SafariOptions newInstance = new SafariOptions();
        this.getCapabilityNames().forEach(name2 -> newInstance.setCapability((String)name2, this.getCapability((String)name2)));
        extraCapabilities.getCapabilityNames().forEach(name2 -> newInstance.setCapability((String)name2, extraCapabilities.getCapability((String)name2)));
        return newInstance;
    }

    public boolean getAutomaticInspection() {
        return Boolean.TRUE.equals(this.getCapability("safari:automaticInspection"));
    }

    public SafariOptions setAutomaticInspection(boolean automaticInspection) {
        this.setCapability("safari:automaticInspection", automaticInspection);
        return this;
    }

    public boolean getAutomaticProfiling() {
        return Boolean.TRUE.equals(this.is("safari:automaticProfiling"));
    }

    public SafariOptions setAutomaticProfiling(boolean automaticProfiling) {
        this.setCapability("safari:automaticProfiling", automaticProfiling);
        return this;
    }

    public boolean getUseTechnologyPreview() {
        return Browser.SAFARI_TECH_PREVIEW.browserName().equals(this.getBrowserName());
    }

    public SafariOptions setUseTechnologyPreview(boolean useTechnologyPreview) {
        super.setCapability("browserName", useTechnologyPreview ? Browser.SAFARI_TECH_PREVIEW.browserName() : Browser.SAFARI.browserName());
        return this;
    }

    @Override
    protected Set<String> getExtraCapabilityNames() {
        return Collections.emptySet();
    }

    @Override
    protected Object getExtraCapability(String capabilityName) {
        return null;
    }

    private static interface Option {
        public static final String AUTOMATIC_INSPECTION = "safari:automaticInspection";
        public static final String AUTOMATIC_PROFILING = "safari:automaticProfiling";
    }
}

