/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariTechPreviewDriverService
extends DriverService {
    public static final String TP_SAFARI_DRIVER_NAME = "safaridriver";
    public static final String TP_SAFARI_DRIVER_EXE_PROPERTY = "webdriver.tp.safari.driver";
    private static final String TP_SAFARI_DRIVER_LOGGING = "webdriver.tp.safari.logging";
    private static final File TP_SAFARI_DRIVER_EXECUTABLE = new File("/Applications/Safari Technology Preview.app/Contents/MacOS/safaridriver");

    @Deprecated
    public SafariTechPreviewDriverService(File executable, int port, List<String> args2, Map<String, String> environment) throws IOException {
        this(executable, port, DEFAULT_TIMEOUT, args2, environment);
    }

    public SafariTechPreviewDriverService(File executable, int port, Duration timeout2, List<String> args2, Map<String, String> environment) throws IOException {
        super(executable, port, timeout2, Collections.unmodifiableList(new ArrayList<String>(args2)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    @Override
    public String getDriverName() {
        return TP_SAFARI_DRIVER_NAME;
    }

    @Override
    public String getDriverProperty() {
        return TP_SAFARI_DRIVER_EXE_PROPERTY;
    }

    @Override
    public File getDriverExecutable() {
        return TP_SAFARI_DRIVER_EXECUTABLE;
    }

    @Override
    protected Capabilities getDefaultDriverOptions() {
        return new SafariOptions().setUseTechnologyPreview(true);
    }

    public static SafariTechPreviewDriverService createDefaultService() {
        return (SafariTechPreviewDriverService)new Builder().build();
    }

    static boolean isPresent() {
        return SafariTechPreviewDriverService.findExePath(TP_SAFARI_DRIVER_EXECUTABLE.getAbsolutePath(), TP_SAFARI_DRIVER_EXE_PROPERTY) != null;
    }

    @Override
    protected void waitUntilAvailable() {
        try {
            PortProber.waitForPortUp(this.getUrl().getPort(), (int)this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            throw new WebDriverException(e);
        }
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<SafariTechPreviewDriverService, Builder> {
        private Boolean diagnose;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.SAFARI_TECH_PREVIEW.browserName().equals(capabilities.getBrowserName())) {
                ++score;
            }
            return score;
        }

        public Builder withLogging(Boolean logging) {
            this.diagnose = logging;
            return this;
        }

        @Override
        public Builder withLogFile(File logFile) {
            throw new WebDriverException("Can not set log location for Safari; use withLogging(true) and locate log in ~/Library/Logs/com.apple.WebDriver/");
        }

        @Override
        protected void loadSystemProperties() {
            if (this.diagnose == null) {
                this.diagnose = Boolean.getBoolean(SafariTechPreviewDriverService.TP_SAFARI_DRIVER_LOGGING);
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList<String> args2 = new ArrayList<String>(Arrays.asList("--port", String.valueOf(this.getPort())));
            if (this.diagnose.booleanValue()) {
                args2.add("--diagnose");
            }
            return args2;
        }

        @Override
        protected SafariTechPreviewDriverService createDriverService(File exe, int port, Duration timeout2, List<String> args2, Map<String, String> environment) {
            try {
                return new SafariTechPreviewDriverService(exe, port, timeout2, args2, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

