/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.support.ui.ISelect;
import org.openqa.selenium.support.ui.Quotes;
import org.openqa.selenium.support.ui.UnexpectedTagNameException;

public class Select
implements ISelect,
WrapsElement {
    private final WebElement element;
    private final boolean isMulti;

    public Select(WebElement element) {
        String tagName = element.getTagName();
        if (null == tagName || !"select".equals(tagName.toLowerCase())) {
            throw new UnexpectedTagNameException("select", tagName);
        }
        this.element = element;
        String value = element.getDomAttribute("multiple");
        this.isMulti = value != null && !"false".equals(value);
    }

    @Override
    public WebElement getWrappedElement() {
        return this.element;
    }

    @Override
    public boolean isMultiple() {
        return this.isMulti;
    }

    @Override
    public List<WebElement> getOptions() {
        return this.element.findElements(By.tagName("option"));
    }

    @Override
    public List<WebElement> getAllSelectedOptions() {
        return this.getOptions().stream().filter(WebElement::isSelected).collect(Collectors.toList());
    }

    @Override
    public WebElement getFirstSelectedOption() {
        return this.getOptions().stream().filter(WebElement::isSelected).findFirst().orElseThrow(() -> new NoSuchElementException("No options are selected"));
    }

    @Override
    public void selectByVisibleText(String text) {
        boolean matched;
        this.assertSelectIsEnabled();
        List<WebElement> options = this.element.findElements(By.xpath(".//option[normalize-space(.) = " + Quotes.escape(text) + "]"));
        for (WebElement option : options) {
            this.setSelected(option, true);
            if (this.isMultiple()) continue;
            return;
        }
        boolean bl = matched = !options.isEmpty();
        if (!matched && text.contains(" ")) {
            String subStringWithoutSpace = this.getLongestSubstringWithoutSpace(text);
            List<WebElement> candidates = "".equals(subStringWithoutSpace) ? this.element.findElements(By.tagName("option")) : this.element.findElements(By.xpath(".//option[contains(., " + Quotes.escape(subStringWithoutSpace) + ")]"));
            String trimmed = text.trim();
            for (WebElement option : candidates) {
                if (!trimmed.equals(option.getText().trim())) continue;
                this.setSelected(option, true);
                if (!this.isMultiple()) {
                    return;
                }
                matched = true;
            }
        }
        if (!matched) {
            throw new NoSuchElementException("Cannot locate option with text: " + text);
        }
    }

    private String getLongestSubstringWithoutSpace(String s) {
        String result = "";
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.length() <= result.length()) continue;
            result = t;
        }
        return result;
    }

    @Override
    public void selectByIndex(int index) {
        this.assertSelectIsEnabled();
        this.setSelectedByIndex(index, true);
    }

    @Override
    public void selectByValue(String value) {
        this.assertSelectIsEnabled();
        for (WebElement option : this.findOptionsByValue(value)) {
            this.setSelected(option, true);
            if (this.isMultiple()) continue;
            return;
        }
    }

    @Override
    public void deselectAll() {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect all options of a multi-select");
        }
        for (WebElement option : this.getOptions()) {
            this.setSelected(option, false);
        }
    }

    @Override
    public void deselectByValue(String value) {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect options of a multi-select");
        }
        for (WebElement option : this.findOptionsByValue(value)) {
            this.setSelected(option, false);
        }
    }

    @Override
    public void deselectByIndex(int index) {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect options of a multi-select");
        }
        this.setSelectedByIndex(index, false);
    }

    @Override
    public void deselectByVisibleText(String text) {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect options of a multi-select");
        }
        List<WebElement> options = this.element.findElements(By.xpath(".//option[normalize-space(.) = " + Quotes.escape(text) + "]"));
        if (options.isEmpty()) {
            throw new NoSuchElementException("Cannot locate option with text: " + text);
        }
        for (WebElement option : options) {
            this.setSelected(option, false);
        }
    }

    private List<WebElement> findOptionsByValue(String value) {
        List<WebElement> options = this.element.findElements(By.xpath(".//option[@value = " + Quotes.escape(value) + "]"));
        if (options.isEmpty()) {
            throw new NoSuchElementException("Cannot locate option with value: " + value);
        }
        return options;
    }

    private void setSelectedByIndex(int index, boolean select) {
        String match = String.valueOf(index);
        for (WebElement option : this.getOptions()) {
            if (!match.equals(option.getAttribute("index"))) continue;
            this.setSelected(option, select);
            return;
        }
        throw new NoSuchElementException("Cannot locate option with index: " + index);
    }

    private void setSelected(WebElement option, boolean select) {
        this.assertOptionIsEnabled(option, select);
        if (option.isSelected() != select) {
            option.click();
        }
    }

    private void assertOptionIsEnabled(WebElement option, boolean select) {
        if (select && !option.isEnabled()) {
            throw new UnsupportedOperationException("You may not select a disabled option");
        }
    }

    private void assertSelectIsEnabled() {
        if (!this.element.isEnabled()) {
            throw new UnsupportedOperationException("You may not select an option in disabled select");
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Select)) {
            return false;
        }
        Select select = (Select)o;
        return Objects.equals(this.element, select.element);
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }
}

