/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.service.processor;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreStreams;
import com.google.auto.common.MoreTypes;
import com.google.auto.service.AutoService;
import com.google.auto.service.processor.ServicesFiles;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedOptions(value={"debug", "verify"})
public class AutoServiceProcessor
extends AbstractProcessor {
    @VisibleForTesting
    static final String MISSING_SERVICES_ERROR = "No service interfaces provided for element!";
    private final List<String> exceptionStacks = Collections.synchronizedList(new ArrayList());
    private final Multimap<String, String> providers = HashMultimap.create();

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of(AutoService.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processImpl(annotations, roundEnv);
        }
        catch (RuntimeException e) {
            String trace = Throwables.getStackTraceAsString(e);
            this.exceptionStacks.add(trace);
            this.fatalError(trace);
        }
        return false;
    }

    ImmutableList<String> exceptionStacks() {
        return ImmutableList.copyOf(this.exceptionStacks);
    }

    private void processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(AutoService.class);
        this.log(annotations.toString());
        this.log(elements.toString());
        for (Element element : elements) {
            TypeElement providerImplementer = MoreElements.asType(element);
            AnnotationMirror annotationMirror = MoreElements.getAnnotationMirror(element, AutoService.class).get();
            ImmutableSet<DeclaredType> providerInterfaces = this.getValueFieldOfClasses(annotationMirror);
            if (providerInterfaces.isEmpty()) {
                this.error(MISSING_SERVICES_ERROR, element, annotationMirror);
                continue;
            }
            for (DeclaredType providerInterface : providerInterfaces) {
                TypeElement providerType = MoreTypes.asTypeElement(providerInterface);
                this.log("provider interface: " + providerType.getQualifiedName());
                this.log("provider implementer: " + providerImplementer.getQualifiedName());
                if (this.checkImplementer(providerImplementer, providerType, annotationMirror)) {
                    this.providers.put(this.getBinaryName(providerType), this.getBinaryName(providerImplementer));
                    continue;
                }
                String message = "ServiceProviders must implement their service provider interface. " + providerImplementer.getQualifiedName() + " does not implement " + providerType.getQualifiedName();
                this.error(message, element, annotationMirror);
            }
        }
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (String providerInterface : this.providers.keySet()) {
            String resourceFile = "META-INF/services/" + providerInterface;
            this.log("Working on resource file: " + resourceFile);
            try {
                TreeSet<String> allServices = Sets.newTreeSet();
                try {
                    FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
                    this.log("Looking for existing resource file at " + existingFile.toUri());
                    Set<String> oldServices = ServicesFiles.readServiceFile(existingFile.openInputStream());
                    this.log("Existing service entries: " + oldServices);
                    allServices.addAll(oldServices);
                }
                catch (IOException e) {
                    this.log("Resource file did not already exist.");
                }
                HashSet<String> newServices = new HashSet<String>(this.providers.get(providerInterface));
                if (!allServices.addAll(newServices)) {
                    this.log("No new service entries being added.");
                    continue;
                }
                this.log("New service file contents: " + allServices);
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                try (OutputStream out = fileObject.openOutputStream();){
                    ServicesFiles.writeServiceFile(allServices, out);
                }
                this.log("Wrote to: " + fileObject.toUri());
            }
            catch (IOException e) {
                this.fatalError("Unable to create " + resourceFile + ", " + e);
                return;
            }
        }
    }

    private boolean checkImplementer(TypeElement providerImplementer, TypeElement providerType, AnnotationMirror annotationMirror) {
        String verify = this.processingEnv.getOptions().get("verify");
        if (verify == null || !Boolean.parseBoolean(verify)) {
            return true;
        }
        Types types = this.processingEnv.getTypeUtils();
        if (types.isSubtype(providerImplementer.asType(), providerType.asType())) {
            return true;
        }
        if (types.isSubtype(providerImplementer.asType(), types.erasure(providerType.asType()))) {
            if (!AutoServiceProcessor.rawTypesSuppressed(providerImplementer)) {
                this.warning("Service provider " + providerType + " is generic, so it can't be named exactly by @AutoService. If this is OK, add @SuppressWarnings(\"rawtypes\").", providerImplementer, annotationMirror);
            }
            return true;
        }
        return false;
    }

    private static boolean rawTypesSuppressed(Element element) {
        while (element != null) {
            SuppressWarnings suppress = element.getAnnotation(SuppressWarnings.class);
            if (suppress != null && Arrays.asList(suppress.value()).contains("rawtypes")) {
                return true;
            }
            element = element.getEnclosingElement();
        }
        return false;
    }

    private String getBinaryName(TypeElement element) {
        return this.getBinaryNameImpl(element, element.getSimpleName().toString());
    }

    private String getBinaryNameImpl(TypeElement element, String className) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement pkg = MoreElements.asPackage(enclosingElement);
            if (pkg.isUnnamed()) {
                return className;
            }
            return pkg.getQualifiedName() + "." + className;
        }
        TypeElement typeElement = MoreElements.asType(enclosingElement);
        return this.getBinaryNameImpl(typeElement, typeElement.getSimpleName() + "$" + className);
    }

    private ImmutableSet<DeclaredType> getValueFieldOfClasses(AnnotationMirror annotationMirror) {
        return AnnotationMirrors.getAnnotationValue(annotationMirror, "value").accept(new SimpleAnnotationValueVisitor8<ImmutableSet<DeclaredType>, Void>(ImmutableSet.of()){

            @Override
            public ImmutableSet<DeclaredType> visitType(TypeMirror typeMirror, Void v) {
                return ImmutableSet.of(MoreTypes.asDeclared(typeMirror));
            }

            @Override
            public ImmutableSet<DeclaredType> visitArray(List<? extends AnnotationValue> values2, Void v) {
                return values2.stream().flatMap(value -> value.accept(this, null).stream()).collect(MoreStreams.toImmutableSet());
            }
        }, null);
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void warning(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, element, annotation);
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }
}

