/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xddf.usermodel.chart;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.util.Internal;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBubbleChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBubbleSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDPt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;

public class XDDFBubbleChartData
extends XDDFChartData {
    private CTBubbleChart chart;

    public XDDFBubbleChartData(XDDFChart parent, CTBubbleChart chart, XDDFChartAxis category, XDDFValueAxis values2) {
        super(parent);
        this.chart = chart;
        Map<Long, XDDFChartAxis> categories2 = null;
        Map<Long, XDDFValueAxis> mapValues = null;
        categories2 = Collections.singletonMap(category.getId(), category);
        mapValues = Collections.singletonMap(values2.getId(), values2);
        for (CTBubbleSer series : chart.getSerList()) {
            this.series.add(new Series(series, series.getXVal(), series.getYVal()));
        }
        this.defineAxes(categories2, mapValues);
    }

    @Internal
    protected XDDFBubbleChartData(XDDFChart parent, CTBubbleChart chart, Map<Long, XDDFChartAxis> categories2, Map<Long, XDDFValueAxis> values2) {
        super(parent);
        this.chart = chart;
        for (CTBubbleSer series : chart.getSerList()) {
            this.series.add(new Series(series, series.getXVal(), series.getYVal()));
        }
        this.defineAxes(categories2, values2);
    }

    private void defineAxes(Map<Long, XDDFChartAxis> categories2, Map<Long, XDDFValueAxis> values2) {
        if (this.chart.sizeOfAxIdArray() == 0) {
            for (Long id : categories2.keySet()) {
                this.chart.addNewAxId().setVal(id);
            }
            for (Long id : values2.keySet()) {
                this.chart.addNewAxId().setVal(id);
            }
        }
        this.defineAxes(this.chart.getAxIdArray(), categories2, values2);
    }

    @Override
    @Internal
    protected void removeCTSeries(int n) {
        this.chart.removeSer(n);
    }

    @Override
    public void setVaryColors(Boolean varyColors) {
        if (varyColors == null) {
            if (this.chart.isSetVaryColors()) {
                this.chart.unsetVaryColors();
            }
        } else if (this.chart.isSetVaryColors()) {
            this.chart.getVaryColors().setVal(varyColors);
        } else {
            this.chart.addNewVaryColors().setVal(varyColors);
        }
    }

    @Override
    public XDDFChartData.Series addSeries(XDDFDataSource<?> category, XDDFNumericalDataSource<? extends Number> values2) {
        long index = this.parent.incrementSeriesCount();
        CTBubbleSer ctSer = this.chart.addNewSer();
        ctSer.addNewXVal();
        ctSer.addNewYVal();
        ctSer.addNewIdx().setVal(index);
        ctSer.addNewOrder().setVal(index);
        Series added = new Series(ctSer, category, values2);
        this.series.add(added);
        return added;
    }

    public class Series
    extends XDDFChartData.Series {
        private CTBubbleSer series;

        protected Series(CTBubbleSer series, XDDFDataSource<?> category, XDDFNumericalDataSource<?> values2) {
            super(category, values2);
            this.series = series;
        }

        public CTBubbleSer getCTBubbleSer() {
            return this.series;
        }

        protected Series(CTBubbleSer series, CTAxDataSource category, CTNumDataSource values2) {
            super(XDDFDataSourcesFactory.fromDataSource(category), XDDFDataSourcesFactory.fromDataSource(values2));
            this.series = series;
        }

        public void setBubbleSizes(XDDFNumericalDataSource<?> values2) {
            if (this.series.isSetBubbleSize()) {
                this.series.unsetBubbleSize();
            }
            CTNumDataSource bubbleSizes = this.series.addNewBubbleSize();
            CTNumData cache = this.retrieveNumCache(bubbleSizes, values2);
            values2.fillNumericalCache(cache);
        }

        @Override
        protected CTSerTx getSeriesText() {
            if (this.series.isSetTx()) {
                return this.series.getTx();
            }
            return this.series.addNewTx();
        }

        @Override
        public void setShowLeaderLines(boolean showLeaderLines) {
            if (!this.series.isSetDLbls()) {
                this.series.addNewDLbls();
            }
            if (this.series.getDLbls().isSetShowLeaderLines()) {
                this.series.getDLbls().getShowLeaderLines().setVal(showLeaderLines);
            } else {
                this.series.getDLbls().addNewShowLeaderLines().setVal(showLeaderLines);
            }
        }

        @Override
        public XDDFShapeProperties getShapeProperties() {
            if (this.series.isSetSpPr()) {
                return new XDDFShapeProperties(this.series.getSpPr());
            }
            return null;
        }

        @Override
        public void setShapeProperties(XDDFShapeProperties properties) {
            if (properties == null) {
                if (this.series.isSetSpPr()) {
                    this.series.unsetSpPr();
                }
            } else if (this.series.isSetSpPr()) {
                this.series.setSpPr(properties.getXmlObject());
            } else {
                this.series.addNewSpPr().set(properties.getXmlObject());
            }
        }

        @Override
        protected CTAxDataSource getAxDS() {
            return this.series.getXVal();
        }

        @Override
        protected CTNumDataSource getNumDS() {
            return this.series.getYVal();
        }

        @Override
        protected void setIndex(long val) {
            this.series.getIdx().setVal(val);
        }

        @Override
        protected void setOrder(long val) {
            this.series.getOrder().setVal(val);
        }

        @Override
        protected List<CTDPt> getDPtList() {
            return this.series.getDPtList();
        }
    }
}

