/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class ChromiumOptions<T extends ChromiumOptions<?>>
extends AbstractDriverOptions<ChromiumOptions<?>> {
    private String binary;
    private final List<String> args = new ArrayList<String>();
    private final List<File> extensionFiles = new ArrayList<File>();
    private final List<String> extensions = new ArrayList<String>();
    private final Map<String, Object> experimentalOptions = new HashMap<String, Object>();
    private Map<String, Object> androidOptions = new HashMap<String, Object>();
    private final String capabilityName;

    public ChromiumOptions(String capabilityType, String browserType, String capability) {
        this.capabilityName = capability;
        this.setCapability(capabilityType, browserType);
        if (!"jdk-http-client".equalsIgnoreCase(System.getProperty("webdriver.http.factory", ""))) {
            this.addArguments("--remote-allow-origins=*");
        }
    }

    public T setBinary(File path) {
        this.binary = Require.nonNull("Path to the chrome executable", path).getPath();
        return (T)this;
    }

    public T setBinary(String path) {
        this.binary = Require.nonNull("Path to the chrome executable", path);
        return (T)this;
    }

    public T addArguments(String ... arguments) {
        this.addArguments(Arrays.asList(arguments));
        return (T)this;
    }

    public T addArguments(List<String> arguments) {
        String remoteAllowOrigins = "remote-allow-origins";
        Optional<String> newArg = arguments.stream().filter(arg -> arg.contains(remoteAllowOrigins)).findFirst();
        Optional<String> existingArg = this.args.stream().filter(arg -> arg.contains(remoteAllowOrigins)).findFirst();
        if (newArg.isPresent() && existingArg.isPresent()) {
            this.args.remove(existingArg.get());
        }
        this.args.addAll(arguments);
        return (T)this;
    }

    public T addExtensions(File ... paths) {
        this.addExtensions(Arrays.asList(paths));
        return (T)this;
    }

    public T addExtensions(List<File> paths) {
        paths.forEach(path -> Require.argument("Extension", path).isFile());
        this.extensionFiles.addAll(paths);
        return (T)this;
    }

    public T addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions(Arrays.asList(encoded));
        return (T)this;
    }

    public T addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Require.nonNull("Encoded extension", extension);
        }
        this.extensions.addAll(encoded);
        return (T)this;
    }

    public T setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put(Require.nonNull("Option name", name), value);
        return (T)this;
    }

    @Deprecated
    public T setHeadless(boolean headless) {
        this.args.remove("--headless");
        if (headless) {
            this.args.add("--headless");
        }
        return (T)this;
    }

    public T setAndroidPackage(String androidPackage) {
        Require.nonNull("Android package", androidPackage);
        return this.setAndroidCapability("androidPackage", androidPackage);
    }

    public T setAndroidActivity(String activity) {
        Require.nonNull("Android activity", activity);
        return this.setAndroidCapability("androidActivity", activity);
    }

    public T setAndroidDeviceSerialNumber(String serial) {
        Require.nonNull("Android device serial number", serial);
        return this.setAndroidCapability("androidDeviceSerial", serial);
    }

    public T setUseRunningAndroidApp(boolean useIt) {
        return this.setAndroidCapability("androidUseRunningApp", useIt);
    }

    public T setAndroidProcess(String processName) {
        Require.nonNull("Android process name", processName);
        return this.setAndroidCapability("androidProcess", processName);
    }

    private T setAndroidCapability(String name, Object value) {
        Require.nonNull("Name", name);
        Require.nonNull("Value", value);
        TreeMap<String, Object> newOptions = new TreeMap<String, Object>(this.androidOptions);
        newOptions.put(name, value);
        this.androidOptions = Collections.unmodifiableMap(newOptions);
        return (T)this;
    }

    @Override
    protected Set<String> getExtraCapabilityNames() {
        return Collections.singleton(this.capabilityName);
    }

    @Override
    protected Object getExtraCapability(String capabilityName) {
        Require.nonNull("Capability name", capabilityName);
        if (!this.capabilityName.equals(capabilityName)) {
            return null;
        }
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        this.experimentalOptions.forEach(options::put);
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", Collections.unmodifiableList(new ArrayList<String>(this.args)));
        options.put("extensions", Collections.unmodifiableList(Stream.concat(this.extensionFiles.stream().map(file -> {
            try {
                return Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
            }
            catch (IOException e) {
                throw new SessionNotCreatedException(e.getMessage(), e);
            }
        }), this.extensions.stream()).collect(Collectors.toList())));
        options.putAll(this.androidOptions);
        return Collections.unmodifiableMap(options);
    }

    protected void mergeInPlace(Capabilities capabilities) {
        Require.nonNull("Capabilities to merge", capabilities);
        for (String name : capabilities.getCapabilityNames()) {
            if (!(name.equals("binary") || name.equals("extensions") || name.equals("args"))) {
                this.setCapability(name, capabilities.getCapability(name));
            }
            if (name.equals("args") && capabilities.getCapability(name) != null) {
                List arguments = (List)capabilities.getCapability("args");
                arguments.forEach(arg -> {
                    if (!this.args.contains(arg)) {
                        this.addArguments((String)arg);
                    }
                });
            }
            if (name.equals("extensions") && capabilities.getCapability(name) != null) {
                List extensionList = (List)capabilities.getCapability("extensions");
                extensionList.forEach(extension -> {
                    if (!this.extensions.contains(extension)) {
                        if (extension instanceof File) {
                            this.addExtensions((File)extension);
                        } else if (extension instanceof String) {
                            this.addEncodedExtensions((String)extension);
                        }
                    }
                });
            }
            if (!name.equals("binary") || capabilities.getCapability(name) == null) continue;
            Object binary = capabilities.getCapability("binary");
            if (binary instanceof String) {
                this.setBinary((String)binary);
                continue;
            }
            if (!(binary instanceof File)) continue;
            this.setBinary((File)binary);
        }
        if (capabilities instanceof ChromiumOptions) {
            ChromiumOptions options = (ChromiumOptions)capabilities;
            for (String arg2 : options.args) {
                if (this.args.contains(arg2)) continue;
                this.addArguments(arg2);
            }
            this.addExtensions(options.extensionFiles);
            this.addEncodedExtensions(options.extensions);
            if (options.binary != null) {
                this.setBinary(options.binary);
            }
            options.experimentalOptions.forEach(this::setExperimentalOption);
        }
    }

    protected void mergeInOptionsFromCaps(String capabilityName, Capabilities capabilities) {
        Object object;
        if (!(capabilities instanceof ChromiumOptions) && (object = capabilities.getCapability(capabilityName)) instanceof Map) {
            Map options = (Map)object;
            List arguments = options.getOrDefault("args", new ArrayList());
            List extensionList = options.getOrDefault("extensions", new ArrayList());
            arguments.forEach(arg -> {
                if (!this.args.contains(arg)) {
                    this.addArguments((String)arg);
                }
            });
            extensionList.forEach(extension -> {
                if (!this.extensions.contains(extension)) {
                    if (extension instanceof File) {
                        this.addExtensions((File)extension);
                    } else if (extension instanceof String) {
                        this.addEncodedExtensions((String)extension);
                    }
                }
            });
            Object binary = options.get("binary");
            if (binary instanceof String) {
                this.setBinary((String)binary);
            } else if (binary instanceof File) {
                this.setBinary((File)binary);
            }
            options.forEach((k, v) -> {
                if (!(k.equals("binary") || k.equals("extensions") || k.equals("args"))) {
                    this.setExperimentalOption((String)k, v);
                }
            });
        }
    }
}

