/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.preload.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v113.page.model.FrameId;
import org.openqa.selenium.devtools.v113.preload.model.PreloadingAttemptKey;
import org.openqa.selenium.devtools.v113.preload.model.PreloadingStatus;
import org.openqa.selenium.json.JsonInput;

public class PrerenderStatusUpdated {
    private final PreloadingAttemptKey key;
    private final FrameId initiatingFrameId;
    private final String prerenderingUrl;
    private final PreloadingStatus status;

    public PrerenderStatusUpdated(PreloadingAttemptKey key, FrameId initiatingFrameId, String prerenderingUrl, PreloadingStatus status) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.status = Objects.requireNonNull(status, "status is required");
    }

    public PreloadingAttemptKey getKey() {
        return this.key;
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrerenderingUrl() {
        return this.prerenderingUrl;
    }

    public PreloadingStatus getStatus() {
        return this.status;
    }

    private static PrerenderStatusUpdated fromJson(JsonInput input) {
        PreloadingAttemptKey key = null;
        FrameId initiatingFrameId = null;
        String prerenderingUrl = null;
        PreloadingStatus status = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "key": {
                    key = (PreloadingAttemptKey)input.read((Type)((Object)PreloadingAttemptKey.class));
                    continue block12;
                }
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block12;
                }
                case "prerenderingUrl": {
                    prerenderingUrl = input.nextString();
                    continue block12;
                }
                case "status": {
                    status = (PreloadingStatus)((Object)input.read((Type)((Object)PreloadingStatus.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderStatusUpdated(key, initiatingFrameId, prerenderingUrl, status);
    }
}

