/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.preload.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v113.network.model.LoaderId;
import org.openqa.selenium.devtools.v113.preload.model.RuleSetErrorType;
import org.openqa.selenium.devtools.v113.preload.model.RuleSetId;
import org.openqa.selenium.json.JsonInput;

public class RuleSet {
    private final RuleSetId id;
    private final LoaderId loaderId;
    private final String sourceText;
    private final Optional<RuleSetErrorType> errorType;
    private final Optional<String> errorMessage;

    public RuleSet(RuleSetId id, LoaderId loaderId, String sourceText, Optional<RuleSetErrorType> errorType, Optional<String> errorMessage) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.sourceText = Objects.requireNonNull(sourceText, "sourceText is required");
        this.errorType = errorType;
        this.errorMessage = errorMessage;
    }

    public RuleSetId getId() {
        return this.id;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public Optional<RuleSetErrorType> getErrorType() {
        return this.errorType;
    }

    @Deprecated
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    private static RuleSet fromJson(JsonInput input) {
        RuleSetId id = null;
        LoaderId loaderId = null;
        String sourceText = null;
        Optional<RuleSetErrorType> errorType = Optional.empty();
        Optional<String> errorMessage = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (RuleSetId)input.read((Type)((Object)RuleSetId.class));
                    continue block14;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read((Type)((Object)LoaderId.class));
                    continue block14;
                }
                case "sourceText": {
                    sourceText = input.nextString();
                    continue block14;
                }
                case "errorType": {
                    errorType = Optional.ofNullable((RuleSetErrorType)((Object)input.read((Type)((Object)RuleSetErrorType.class))));
                    continue block14;
                }
                case "errorMessage": {
                    errorMessage = Optional.ofNullable(input.nextString());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RuleSet(id, loaderId, sourceText, errorType, errorMessage);
    }
}

