/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.runtime.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class WebDriverValue {
    private final Type type;
    private final Optional<Object> value;
    private final Optional<String> objectId;

    public WebDriverValue(Type type, Optional<Object> value, Optional<String> objectId) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.objectId = objectId;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Object> getValue() {
        return this.value;
    }

    public Optional<String> getObjectId() {
        return this.objectId;
    }

    private static WebDriverValue fromJson(JsonInput input) {
        Type type = null;
        Optional<Object> value = Optional.empty();
        Optional<String> objectId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block10;
                }
                case "value": {
                    value = Optional.ofNullable(input.read((java.lang.reflect.Type)((Object)Object.class)));
                    continue block10;
                }
                case "objectId": {
                    objectId = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WebDriverValue(type, value, objectId);
    }

    public static enum Type {
        UNDEFINED("undefined"),
        NULL("null"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        BIGINT("bigint"),
        REGEXP("regexp"),
        DATE("date"),
        SYMBOL("symbol"),
        ARRAY("array"),
        OBJECT("object"),
        FUNCTION("function"),
        MAP("map"),
        SET("set"),
        WEAKMAP("weakmap"),
        WEAKSET("weakset"),
        ERROR("error"),
        PROXY("proxy"),
        PROMISE("promise"),
        TYPEDARRAY("typedarray"),
        ARRAYBUFFER("arraybuffer"),
        NODE("node"),
        WINDOW("window");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s2) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

