/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.target.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v113.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class TargetCrashed {
    private final TargetID targetId;
    private final String status;
    private final Integer errorCode;

    public TargetCrashed(TargetID targetId, String status, Integer errorCode) {
        this.targetId = Objects.requireNonNull(targetId, "targetId is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is required");
    }

    public TargetID getTargetId() {
        return this.targetId;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    private static TargetCrashed fromJson(JsonInput input) {
        TargetID targetId = null;
        String status = null;
        Integer errorCode = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "targetId": {
                    targetId = (TargetID)input.read((Type)((Object)TargetID.class));
                    continue block10;
                }
                case "status": {
                    status = input.nextString();
                    continue block10;
                }
                case "errorCode": {
                    errorCode = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TargetCrashed(targetId, status, errorCode);
    }
}

