/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.fedcm;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v114.fedcm.model.DialogShown;

@Beta
public class FedCm {
    public static Command<Void> enable(Optional<Boolean> disableRejectionDelay) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        disableRejectionDelay.ifPresent(p -> params.put("disableRejectionDelay", p));
        return new Command<Void>("FedCm.enable", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("FedCm.disable", params.build());
    }

    public static Command<Void> selectAccount(String dialogId, Integer accountIndex) {
        Objects.requireNonNull(dialogId, "dialogId is required");
        Objects.requireNonNull(accountIndex, "accountIndex is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("dialogId", dialogId);
        params.put("accountIndex", accountIndex);
        return new Command<Void>("FedCm.selectAccount", params.build());
    }

    public static Command<Void> dismissDialog(String dialogId, Optional<Boolean> triggerCooldown) {
        Objects.requireNonNull(dialogId, "dialogId is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("dialogId", dialogId);
        triggerCooldown.ifPresent(p -> params.put("triggerCooldown", (String)p));
        return new Command<Void>("FedCm.dismissDialog", params.build());
    }

    public static Command<Void> resetCooldown() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("FedCm.resetCooldown", params.build());
    }

    public static Event<DialogShown> dialogShown() {
        return new Event<DialogShown>("FedCm.dialogShown", input -> (DialogShown)input.read((Type)((Object)DialogShown.class)));
    }
}

