/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v114.network.model.AuthChallenge;
import org.openqa.selenium.devtools.v114.network.model.ErrorReason;
import org.openqa.selenium.devtools.v114.network.model.Headers;
import org.openqa.selenium.devtools.v114.network.model.InterceptionId;
import org.openqa.selenium.devtools.v114.network.model.Request;
import org.openqa.selenium.devtools.v114.network.model.RequestId;
import org.openqa.selenium.devtools.v114.network.model.ResourceType;
import org.openqa.selenium.devtools.v114.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Beta
@Deprecated
public class RequestIntercepted {
    private final InterceptionId interceptionId;
    private final Request request;
    private final FrameId frameId;
    private final ResourceType resourceType;
    private final Boolean isNavigationRequest;
    private final Optional<Boolean> isDownload;
    private final Optional<String> redirectUrl;
    private final Optional<AuthChallenge> authChallenge;
    private final Optional<ErrorReason> responseErrorReason;
    private final Optional<Integer> responseStatusCode;
    private final Optional<Headers> responseHeaders;
    private final Optional<RequestId> requestId;

    public RequestIntercepted(InterceptionId interceptionId, Request request, FrameId frameId, ResourceType resourceType, Boolean isNavigationRequest, Optional<Boolean> isDownload, Optional<String> redirectUrl, Optional<AuthChallenge> authChallenge, Optional<ErrorReason> responseErrorReason, Optional<Integer> responseStatusCode, Optional<Headers> responseHeaders, Optional<RequestId> requestId) {
        this.interceptionId = Objects.requireNonNull(interceptionId, "interceptionId is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType is required");
        this.isNavigationRequest = Objects.requireNonNull(isNavigationRequest, "isNavigationRequest is required");
        this.isDownload = isDownload;
        this.redirectUrl = redirectUrl;
        this.authChallenge = authChallenge;
        this.responseErrorReason = responseErrorReason;
        this.responseStatusCode = responseStatusCode;
        this.responseHeaders = responseHeaders;
        this.requestId = requestId;
    }

    public InterceptionId getInterceptionId() {
        return this.interceptionId;
    }

    public Request getRequest() {
        return this.request;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Boolean getIsNavigationRequest() {
        return this.isNavigationRequest;
    }

    public Optional<Boolean> getIsDownload() {
        return this.isDownload;
    }

    public Optional<String> getRedirectUrl() {
        return this.redirectUrl;
    }

    public Optional<AuthChallenge> getAuthChallenge() {
        return this.authChallenge;
    }

    public Optional<ErrorReason> getResponseErrorReason() {
        return this.responseErrorReason;
    }

    public Optional<Integer> getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public Optional<Headers> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Optional<RequestId> getRequestId() {
        return this.requestId;
    }

    private static RequestIntercepted fromJson(JsonInput input) {
        InterceptionId interceptionId = null;
        Request request = null;
        FrameId frameId = null;
        ResourceType resourceType = null;
        Boolean isNavigationRequest = false;
        Optional<Boolean> isDownload = Optional.empty();
        Optional<String> redirectUrl = Optional.empty();
        Optional<AuthChallenge> authChallenge = Optional.empty();
        Optional<ErrorReason> responseErrorReason = Optional.empty();
        Optional<Integer> responseStatusCode = Optional.empty();
        Optional<Headers> responseHeaders = Optional.empty();
        Optional<RequestId> requestId = Optional.empty();
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "interceptionId": {
                    interceptionId = (InterceptionId)input.read((Type)((Object)InterceptionId.class));
                    continue block28;
                }
                case "request": {
                    request = (Request)input.read((Type)((Object)Request.class));
                    continue block28;
                }
                case "frameId": {
                    frameId = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block28;
                }
                case "resourceType": {
                    resourceType = (ResourceType)((Object)input.read((Type)((Object)ResourceType.class)));
                    continue block28;
                }
                case "isNavigationRequest": {
                    isNavigationRequest = input.nextBoolean();
                    continue block28;
                }
                case "isDownload": {
                    isDownload = Optional.ofNullable(input.nextBoolean());
                    continue block28;
                }
                case "redirectUrl": {
                    redirectUrl = Optional.ofNullable(input.nextString());
                    continue block28;
                }
                case "authChallenge": {
                    authChallenge = Optional.ofNullable((AuthChallenge)input.read((Type)((Object)AuthChallenge.class)));
                    continue block28;
                }
                case "responseErrorReason": {
                    responseErrorReason = Optional.ofNullable((ErrorReason)((Object)input.read((Type)((Object)ErrorReason.class))));
                    continue block28;
                }
                case "responseStatusCode": {
                    responseStatusCode = Optional.ofNullable(input.nextNumber().intValue());
                    continue block28;
                }
                case "responseHeaders": {
                    responseHeaders = Optional.ofNullable((Headers)input.read((Type)((Object)Headers.class)));
                    continue block28;
                }
                case "requestId": {
                    requestId = Optional.ofNullable((RequestId)input.read((Type)((Object)RequestId.class)));
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestIntercepted(interceptionId, request, frameId, resourceType, isNavigationRequest, isDownload, redirectUrl, authChallenge, responseErrorReason, responseStatusCode, responseHeaders, requestId);
    }
}

