/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.runtime.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v114.runtime.model.CustomPreview;
import org.openqa.selenium.devtools.v114.runtime.model.ObjectPreview;
import org.openqa.selenium.devtools.v114.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v114.runtime.model.UnserializableValue;
import org.openqa.selenium.devtools.v114.runtime.model.WebDriverValue;
import org.openqa.selenium.json.JsonInput;

public class RemoteObject {
    private final Type type;
    private final Optional<Subtype> subtype;
    private final Optional<String> className;
    private final Optional<Object> value;
    private final Optional<UnserializableValue> unserializableValue;
    private final Optional<String> description;
    private final Optional<WebDriverValue> webDriverValue;
    private final Optional<RemoteObjectId> objectId;
    private final Optional<ObjectPreview> preview;
    private final Optional<CustomPreview> customPreview;

    public RemoteObject(Type type, Optional<Subtype> subtype, Optional<String> className, Optional<Object> value, Optional<UnserializableValue> unserializableValue, Optional<String> description, Optional<WebDriverValue> webDriverValue, Optional<RemoteObjectId> objectId, Optional<ObjectPreview> preview, Optional<CustomPreview> customPreview) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.subtype = subtype;
        this.className = className;
        this.value = value;
        this.unserializableValue = unserializableValue;
        this.description = description;
        this.webDriverValue = webDriverValue;
        this.objectId = objectId;
        this.preview = preview;
        this.customPreview = customPreview;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Subtype> getSubtype() {
        return this.subtype;
    }

    public Optional<String> getClassName() {
        return this.className;
    }

    public Optional<Object> getValue() {
        return this.value;
    }

    public Optional<UnserializableValue> getUnserializableValue() {
        return this.unserializableValue;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    @Beta
    public Optional<WebDriverValue> getWebDriverValue() {
        return this.webDriverValue;
    }

    public Optional<RemoteObjectId> getObjectId() {
        return this.objectId;
    }

    @Beta
    public Optional<ObjectPreview> getPreview() {
        return this.preview;
    }

    @Beta
    public Optional<CustomPreview> getCustomPreview() {
        return this.customPreview;
    }

    private static RemoteObject fromJson(JsonInput input) {
        Type type = null;
        Optional<Subtype> subtype = Optional.empty();
        Optional<String> className = Optional.empty();
        Optional<Object> value = Optional.empty();
        Optional<UnserializableValue> unserializableValue = Optional.empty();
        Optional<String> description = Optional.empty();
        Optional<WebDriverValue> webDriverValue = Optional.empty();
        Optional<RemoteObjectId> objectId = Optional.empty();
        Optional<ObjectPreview> preview = Optional.empty();
        Optional<CustomPreview> customPreview = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block24;
                }
                case "subtype": {
                    subtype = Optional.ofNullable(Subtype.fromString(input.nextString()));
                    continue block24;
                }
                case "className": {
                    className = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "value": {
                    value = Optional.ofNullable(input.read((java.lang.reflect.Type)((Object)Object.class)));
                    continue block24;
                }
                case "unserializableValue": {
                    unserializableValue = Optional.ofNullable((UnserializableValue)input.read((java.lang.reflect.Type)((Object)UnserializableValue.class)));
                    continue block24;
                }
                case "description": {
                    description = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "webDriverValue": {
                    webDriverValue = Optional.ofNullable((WebDriverValue)input.read((java.lang.reflect.Type)((Object)WebDriverValue.class)));
                    continue block24;
                }
                case "objectId": {
                    objectId = Optional.ofNullable((RemoteObjectId)input.read((java.lang.reflect.Type)((Object)RemoteObjectId.class)));
                    continue block24;
                }
                case "preview": {
                    preview = Optional.ofNullable((ObjectPreview)input.read((java.lang.reflect.Type)((Object)ObjectPreview.class)));
                    continue block24;
                }
                case "customPreview": {
                    customPreview = Optional.ofNullable((CustomPreview)input.read((java.lang.reflect.Type)((Object)CustomPreview.class)));
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RemoteObject(type, subtype, className, value, unserializableValue, description, webDriverValue, objectId, preview, customPreview);
    }

    public static enum Subtype {
        ARRAY("array"),
        NULL("null"),
        NODE("node"),
        REGEXP("regexp"),
        DATE("date"),
        MAP("map"),
        SET("set"),
        WEAKMAP("weakmap"),
        WEAKSET("weakset"),
        ITERATOR("iterator"),
        GENERATOR("generator"),
        ERROR("error"),
        PROXY("proxy"),
        PROMISE("promise"),
        TYPEDARRAY("typedarray"),
        ARRAYBUFFER("arraybuffer"),
        DATAVIEW("dataview"),
        WEBASSEMBLYMEMORY("webassemblymemory"),
        WASMVALUE("wasmvalue");

        private String value;

        private Subtype(String value) {
            this.value = value;
        }

        public static Subtype fromString(String s2) {
            return Arrays.stream(Subtype.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Subtype "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Subtype fromJson(JsonInput input) {
            return Subtype.fromString(input.nextString());
        }
    }

    public static enum Type {
        OBJECT("object"),
        FUNCTION("function"),
        UNDEFINED("undefined"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        SYMBOL("symbol"),
        BIGINT("bigint");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s2) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

