/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v114.security.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum SecurityState {
    UNKNOWN("unknown"),
    NEUTRAL("neutral"),
    INSECURE("insecure"),
    SECURE("secure"),
    INFO("info"),
    INSECURE_BROKEN("insecure-broken");

    private String value;

    private SecurityState(String value) {
        this.value = value;
    }

    public static SecurityState fromString(String s2) {
        return Arrays.stream(SecurityState.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SecurityState "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SecurityState fromJson(JsonInput input) {
        return SecurityState.fromString(input.nextString());
    }
}

