/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.decorators;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openqa.selenium.support.decorators.Decorated;
import org.openqa.selenium.support.decorators.WebDriverDecorator;

public class DefaultDecorated<T>
implements Decorated<T> {
    private final T original;
    private final WebDriverDecorator<?> decorator;

    public DefaultDecorated(T original, WebDriverDecorator<?> decorator) {
        this.original = original;
        this.decorator = decorator;
    }

    @Override
    public final T getOriginal() {
        return this.original;
    }

    @Override
    public final WebDriverDecorator<?> getDecorator() {
        return this.decorator;
    }

    @Override
    public void beforeCall(Method method, Object[] args2) {
        this.getDecorator().beforeCall(this, method, args2);
    }

    @Override
    public Object call(Method method, Object[] args2) throws Throwable {
        return this.getDecorator().call(this, method, args2);
    }

    @Override
    public void afterCall(Method method, Object result, Object[] args2) {
        this.getDecorator().afterCall(this, method, args2, result);
    }

    @Override
    public Object onError(Method method, InvocationTargetException e, Object[] args2) throws Throwable {
        return this.getDecorator().onError(this, method, args2, e);
    }

    public String toString() {
        return String.format("Decorated {%s}", this.original);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Decorated) {
            Decorated that = (Decorated)o;
            return this.original.equals(that.getOriginal());
        }
        return this.original.equals(o);
    }

    public int hashCode() {
        return this.original.hashCode();
    }
}

